/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.auto.common.MoreTypes;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.jboss.hal.processor.mbui.Attribute;
import org.jboss.hal.processor.mbui.ExpressionParser;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MbuiViewProcessor;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.TypeParameter;
import org.jboss.hal.processor.mbui.XmlHelper;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.jetbrains.annotations.NonNls;

abstract class AbstractMbuiElementProcessor
implements MbuiElementProcessor {
    @NonNls
    final MbuiViewProcessor processor;
    private final Elements elementUtils;
    final XPathFactory xPathFactory;

    AbstractMbuiElementProcessor(MbuiViewProcessor processor, Elements elementUtils, XPathFactory xPathFactory) {
        this.processor = processor;
        this.elementUtils = elementUtils;
        this.xPathFactory = xPathFactory;
    }

    MetadataInfo findMetadata(VariableElement field, Element element, MbuiViewContext context) {
        MetadataInfo metadataInfo = null;
        XPathExpression expression = this.xPathFactory.compile("ancestor::metadata", Filters.element());
        Element metadataElement = (Element)expression.evaluateFirst((Object)element);
        if (metadataElement == null) {
            this.processor.error(field, "Missing metadata ancestor for %s#%s. Please make sure the there's a <%s/> ancestor element.", new Object[]{element.getName(), element.getAttributeValue("id"), "metadata"});
        } else {
            metadataInfo = context.getMetadataInfo(metadataElement.getAttributeValue("address"));
            if (metadataInfo == null) {
                this.processor.error(field, "No metadata found for %s#%s. Please make sure there's a <%s/> ancestor element.", new Object[]{element.getName(), element.getAttributeValue("id"), "metadata"});
            }
        }
        return metadataInfo;
    }

    TypeParameter getTypeParameter(VariableElement field) {
        TypeMirror type = this.elementUtils.getTypeElement("org.jboss.hal.dmr.ModelNode").asType();
        DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)field.asType());
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            type = typeArguments.get(0);
        }
        return new TypeParameter(MoreTypes.asTypeElement((TypeMirror)type).getQualifiedName().toString());
    }

    List<Attribute> processAttributes(VariableElement field, Element attributesContainer) {
        return attributesContainer.getChildren("attribute").stream().map(element -> this.processAttribute(field, (Element)element)).collect(Collectors.toList());
    }

    Attribute processAttribute(VariableElement field, Element attributeElement) {
        Element templatesContainer;
        String name = attributeElement.getAttributeValue("name");
        String provider = attributeElement.getAttributeValue("provider");
        String formItem = attributeElement.getAttributeValue("form-item");
        String validationHandler = attributeElement.getAttributeValue("validation-handler");
        String suggestHandlerAttribute = attributeElement.getAttributeValue("suggest-handler");
        Element suggestHandlerElement = attributeElement.getChild("suggest-handler");
        if (name == null && formItem == null) {
            this.processor.error(field, "Invalid attribute \"%s\": name is mandatory.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
        }
        if (provider != null && !ExpressionParser.isExpression(provider)) {
            this.processor.error(field, "Provider for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
        }
        if (formItem != null && !ExpressionParser.isExpression(formItem)) {
            this.processor.error(field, "FormItem for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
        }
        if (validationHandler != null && !ExpressionParser.isExpression(validationHandler)) {
            this.processor.error(field, "Validation handler for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
        }
        if (suggestHandlerAttribute != null && !ExpressionParser.isExpression(suggestHandlerAttribute)) {
            this.processor.error(field, "Suggestion handler for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
        }
        if (suggestHandlerAttribute != null && suggestHandlerElement != null) {
            this.processor.error(field, "Invalid suggest handler for attribute \"%s\": Please specify suggest handler as attribute or child element, not both", new Object[]{XmlHelper.xmlAsString(attributeElement)});
        }
        Attribute attribute = new Attribute(name, provider, formItem, validationHandler, suggestHandlerAttribute);
        if (suggestHandlerElement != null && (templatesContainer = suggestHandlerElement.getChild("templates")) != null) {
            for (Element templateElement : templatesContainer.getChildren("template")) {
                String address = templateElement.getAttributeValue("address");
                attribute.addSuggestHandlerTemplate(address);
            }
        }
        return attribute;
    }
}

