/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.gwtplatform.mvp.client.annotations.NameToken;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.auto.AbstractProcessor;
import org.jboss.hal.processor.RegistryBinding;
import org.jboss.hal.spi.Keywords;
import org.jboss.hal.spi.Scope;

@SupportedAnnotationTypes(value={"com.gwtplatform.mvp.client.annotations.NameToken"})
@AutoService(value={Processor.class})
public class NameTokenProcessor
extends AbstractProcessor {
    private static final String NAME_TOKEN_TEMPLATE = "NameTokens.ftl";
    private static final String NAME_TOKEN_PACKAGE = "org.jboss.hal.meta.token";
    private static final String NAME_TOKEN_CLASS = "NameTokensImpl";
    private static final String SEARCH_INDEX_TEMPLATE = "SearchIndex.ftl";
    private static final String SEARCH_INDEX_PACKAGE = "org.jboss.hal.meta.search";
    private static final String SEARCH_INDEX_CLASS = "SearchIndexImpl";
    private static final String REGISTRY_MODULE_TEMPLATE = "RegistryModule.ftl";
    private static final String REGISTRY_MODULE_PACKAGE = "org.jboss.hal.meta";
    private static final String REGISTRY_MODULE_CLASS = "NameTokenRegistriesModule";
    private final Set<TokenInfo> tokenInfos = new HashSet<TokenInfo>();

    public NameTokenProcessor() {
        super(NameTokenProcessor.class, "templates");
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(NameToken.class)) {
            TypeElement tokenElement = (TypeElement)element;
            NameToken nameToken = tokenElement.getAnnotation(NameToken.class);
            TokenInfo tokenInfo = new TokenInfo(nameToken.value()[0]);
            this.tokenInfos.add(tokenInfo);
            Keywords keywords = tokenElement.getAnnotation(Keywords.class);
            if (keywords == null) continue;
            tokenInfo.addKeywords(keywords.value());
            tokenInfo.setExclude(keywords.exclude());
            Scope scope = tokenElement.getAnnotation(Scope.class);
            if (scope == null) continue;
            tokenInfo.setDomainOnly(scope.value() == Scope.Mode.DOMAIN);
            tokenInfo.setStandaloneOnly(scope.value() == Scope.Mode.STANDALONE);
        }
        if (!this.tokenInfos.isEmpty()) {
            this.debug("Generating code for name token registry", new Object[0]);
            this.code(NAME_TOKEN_TEMPLATE, NAME_TOKEN_PACKAGE, NAME_TOKEN_CLASS, this.context(NAME_TOKEN_PACKAGE, NAME_TOKEN_CLASS));
            this.debug("Generating code for search index registry", new Object[0]);
            this.code(SEARCH_INDEX_TEMPLATE, SEARCH_INDEX_PACKAGE, SEARCH_INDEX_CLASS, this.context(SEARCH_INDEX_PACKAGE, SEARCH_INDEX_CLASS));
            ImmutableList bindings = ImmutableList.of((Object)new RegistryBinding("org.jboss.hal.meta.token.NameTokens", "org.jboss.hal.meta.token.NameTokensImpl"), (Object)new RegistryBinding("org.jboss.hal.meta.search.SearchIndex", "org.jboss.hal.meta.search.SearchIndexImpl"));
            this.debug("Generating code for registry module", new Object[0]);
            this.code(REGISTRY_MODULE_TEMPLATE, REGISTRY_MODULE_PACKAGE, REGISTRY_MODULE_CLASS, () -> NameTokenProcessor.lambda$onProcess$0((List)bindings));
            this.info("Successfully generated name token registries [%s], [%s] and related module [%s].", new Object[]{NAME_TOKEN_CLASS, SEARCH_INDEX_CLASS, REGISTRY_MODULE_CLASS});
            this.tokenInfos.clear();
        }
        return false;
    }

    private Supplier<Map<String, Object>> context(String packageName, String className) {
        return () -> {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("generatedWith", NameTokenProcessor.class.getName());
            context.put("packageName", packageName);
            context.put("className", className);
            context.put("tokenInfos", this.tokenInfos);
            return context;
        };
    }

    private static /* synthetic */ Map lambda$onProcess$0(List bindings) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("generatedWith", NameTokenProcessor.class.getName());
        context.put("packageName", REGISTRY_MODULE_PACKAGE);
        context.put("className", REGISTRY_MODULE_CLASS);
        context.put("bindings", bindings);
        return context;
    }

    public static class TokenInfo {
        private final String token;
        private final Set<String> resources;
        private boolean recursive;
        private final Set<String> keywords;
        private boolean exclude;
        private boolean domainOnly;
        private boolean standaloneOnly;

        TokenInfo(String token) {
            this.token = token;
            this.resources = new HashSet<String>();
            this.recursive = false;
            this.keywords = new HashSet<String>();
            this.exclude = false;
            this.domainOnly = false;
            this.standaloneOnly = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenInfo)) {
                return false;
            }
            TokenInfo that = (TokenInfo)o;
            return this.token.equals(that.token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "TokenInfo{" + this.token + "}";
        }

        public boolean isExclude() {
            return this.exclude;
        }

        void setExclude(boolean exclude) {
            this.exclude = exclude;
        }

        public Set<String> getKeywords() {
            return this.keywords;
        }

        void addKeywords(String[] keywords) {
            this.keywords.addAll(Arrays.asList(keywords));
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public Set<String> getResources() {
            return this.resources;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isDomainOnly() {
            return this.domainOnly;
        }

        void setDomainOnly(boolean domainOnly) {
            this.domainOnly = domainOnly;
        }

        public boolean isStandaloneOnly() {
            return this.standaloneOnly;
        }

        void setStandaloneOnly(boolean standaloneOnly) {
            this.standaloneOnly = standaloneOnly;
        }
    }
}

