/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.gwtplatform.mvp.client.annotations.NameToken;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.auto.AbstractProcessor;
import org.jboss.hal.processor.RegistryBinding;
import org.jboss.hal.spi.AsyncColumn;
import org.jboss.hal.spi.Column;
import org.jboss.hal.spi.Requires;

@SupportedAnnotationTypes(value={"org.jboss.hal.spi.Requires"})
@AutoService(value={Processor.class})
public class RequiredResourcesProcessor
extends AbstractProcessor {
    private static final String REQUIRED_RESOURCES_TEMPLATE = "RequiredResources.ftl";
    private static final String REQUIRED_RESOURCES_PACKAGE = "org.jboss.hal.meta.resource";
    private static final String REQUIRED_RESOURCES_CLASS = "RequiredResourcesImpl";
    private static final String REGISTRY_MODULE_TEMPLATE = "RegistryModule.ftl";
    private static final String REGISTRY_MODULE_PACKAGE = "org.jboss.hal.meta";
    private static final String REGISTRY_MODULE_CLASS = "RequiredResourcesRegistryModule";
    private final Map<String, RequiredInfo> requiredInfos = new HashMap<String, RequiredInfo>();

    public RequiredResourcesProcessor() {
        super(RequiredResourcesProcessor.class, "templates");
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Requires.class)) {
            TypeElement requiredElement = (TypeElement)element;
            Requires requires = requiredElement.getAnnotation(Requires.class);
            String id = null;
            NameToken token = requiredElement.getAnnotation(NameToken.class);
            if (token != null) {
                id = token.value()[0];
            } else {
                AsyncColumn asyncColumn = requiredElement.getAnnotation(AsyncColumn.class);
                if (asyncColumn != null) {
                    id = asyncColumn.value();
                } else {
                    Column column = requiredElement.getAnnotation(Column.class);
                    if (column != null) {
                        id = column.value();
                    }
                }
            }
            if (id == null) continue;
            RequiredInfo requiredInfo = new RequiredInfo(id, requiredElement);
            requiredInfo.addResources(requires.value());
            requiredInfo.setRecursive(requires.recursive());
            if (this.requiredInfos.containsKey(id)) {
                RequiredInfo other = this.requiredInfos.get(id);
                if (!requiredInfo.getResources().equals(other.getResources())) {
                    this.error(requiredElement, "Different required resources for the same id \"%s\". This class conflicts with %s", new Object[]{id, other.source.getQualifiedName()});
                }
            }
            this.requiredInfos.put(id, requiredInfo);
        }
        if (!this.requiredInfos.isEmpty()) {
            this.debug("Generating code for required resources registry", new Object[0]);
            this.code(REQUIRED_RESOURCES_TEMPLATE, REQUIRED_RESOURCES_PACKAGE, REQUIRED_RESOURCES_CLASS, this.context(REQUIRED_RESOURCES_PACKAGE, REQUIRED_RESOURCES_CLASS));
            ImmutableList bindings = ImmutableList.of((Object)new RegistryBinding("org.jboss.hal.meta.resource.RequiredResources", "org.jboss.hal.meta.resource.RequiredResourcesImpl"));
            this.debug("Generating code for registry module", new Object[0]);
            this.code(REGISTRY_MODULE_TEMPLATE, REGISTRY_MODULE_PACKAGE, REGISTRY_MODULE_CLASS, () -> RequiredResourcesProcessor.lambda$onProcess$0((List)bindings));
            this.info("Successfully generated required resources registry [%s] and related module [%s].", new Object[]{REQUIRED_RESOURCES_CLASS, REGISTRY_MODULE_CLASS});
            this.requiredInfos.clear();
        }
        return false;
    }

    private Supplier<Map<String, Object>> context(String packageName, String className) {
        return () -> {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("generatedWith", RequiredResourcesProcessor.class.getName());
            context.put("packageName", packageName);
            context.put("className", className);
            context.put("requiredInfos", this.requiredInfos.values());
            return context;
        };
    }

    private static /* synthetic */ Map lambda$onProcess$0(List bindings) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("generatedWith", RequiredResourcesProcessor.class.getName());
        context.put("packageName", REGISTRY_MODULE_PACKAGE);
        context.put("className", REGISTRY_MODULE_CLASS);
        context.put("bindings", bindings);
        return context;
    }

    public static class RequiredInfo {
        private final String id;
        private final TypeElement source;
        private final Set<String> resources;
        private boolean recursive;

        RequiredInfo(String id, TypeElement source) {
            this.id = id;
            this.source = source;
            this.resources = new HashSet<String>();
            this.recursive = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequiredInfo)) {
                return false;
            }
            RequiredInfo that = (RequiredInfo)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "RequiredInfo{" + this.id + "}";
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public Set<String> getResources() {
            return this.resources;
        }

        public void addResources(String[] resources) {
            this.resources.addAll(Arrays.asList(resources));
        }

        public String getId() {
            return this.id;
        }
    }
}

