/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.auto.AbstractProcessor;
import org.jboss.hal.spi.GinModule;

@SupportedAnnotationTypes(value={"org.jboss.hal.spi.GinModule"})
@AutoService(value={Processor.class})
public class GinModuleProcessor
extends AbstractProcessor {
    private static final String MODULE_TEMPLATE = "CompositeModule.ftl";
    private static final String MODULE_PACKAGE = "org.jboss.hal.client.gin";
    private static final String MODULE_CLASS = "CompositeModule";
    private final Set<String> modules = new HashSet<String>();

    public GinModuleProcessor() {
        super(GinModuleProcessor.class, "templates");
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> roundModules = roundEnv.getElementsAnnotatedWith(GinModule.class);
        for (Element element : roundModules) {
            TypeElement moduleElement = (TypeElement)element;
            this.modules.add(moduleElement.getQualifiedName().toString());
            this.debug("Added %s as GIN module", new Object[]{moduleElement.getQualifiedName()});
        }
        if (this.round() == 1 && !this.modules.isEmpty()) {
            this.debug("Generating composite GIN module", new Object[0]);
            this.code(MODULE_TEMPLATE, MODULE_PACKAGE, MODULE_CLASS, () -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("generatedWith", GinModuleProcessor.class.getName());
                context.put("packageName", MODULE_PACKAGE);
                context.put("className", MODULE_CLASS);
                context.put("modules", this.modules);
                return context;
            });
            this.info("Successfully generated composite GIN module [%s] based on \n\t%s.", new Object[]{MODULE_CLASS, Joiner.on((String)"\n\t").join(this.modules)});
            this.modules.clear();
        }
        return false;
    }
}

