/*
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.hal.resources;

/**
 * Common names and terms which are not meant to be translated.
 *
 * @author Harald Pehl
 */
public interface Names {

    String ACCESS_CONTROL = "Access Control";
    String CONFIGURATION = "Configuration";
    String DATASOURCE = "Datasource";
    String DATASOURCES = "Datasources";
    String DATASOURCES_DRIVERS = "Datasources & Drivers";
    String DEPLOYMENT = "Deployment";
    String DEPLOYMENTS = "Deployments";
    String DOMAIN_CONTROLLER = "Domain Controller";
    String EE = "EE";
    String GLOBAL_MODULES = "Global Modules";
    String HAL = "HAL";
    String HEAP = "Heap";
    String HOST = "Host";
    String HOST_CONTROLLER = "Host Controller";
    String HOSTS = "Hosts";
    String INTERFACE = "Interface";
    String INTERFACES = "Interfaces";
    String JDBC_DRIVER = "JDBC Driver";
    String JDBC_DRIVERS = "JDBC Drivers";
    String JVM = "JVM";
    String LOGGING = "Logging";
    String LOGGING_PROFILE = "Logging Profile";
    String LOGGING_PROFILES = "Logging Profiles";
    String MAIL_SESSION = "Mail Session";
    String MANAGEMENT_CONSOLE = "Management Console";
    String MANAGEMENT_MODEL = "Management Model";
    String MB = "MB";
    String MODULE = "Module";
    String NAME = "Name";
    String NOT_AVAILABLE = "n/a";
    String NOT_SUPPORTED = "not supported";
    String NYI = "not yet implemented";
    String PATCHING = "Patching";
    String PATHS = "Paths";
    String PROFILE = "Profile";
    String PROFILES = "Profiles";
    String RESOURCE = "Resource";
    String ROOT_LOGGER = "Root Logger";
    String RUNTIME = "Runtime";
    String SERVER = "Server";
    String SERVER_GROUP = "Server Group";
    String SERVER_GROUPS = "Server Groups";
    String SOCKET_BINDING = "Socket Binding";
    String SOCKET_BINDINGS = "Socket Bindings";
    String SUBSYSTEM = "Subsystem";
    String SUBSYSTEMS = "Subsystems";
    String SYSTEM_PROPERTIES = "System Properties";
    String THREADS = "Threads";
    String TOPOLOGY = "Topology";
    String UNKNOWN= "unknown";
    String XA_DATASOURCE = "XA Datasource";
}
