/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.core;

public final class Strings {
    private static final int INDEX_NOT_FOUND = -1;
    private static final String ELLIPSIS = "...";
    private static final String EMPTY = "";
    private static final String SCHEME_HOST_SEPARATOR = "://";
    private static final String FQ_CLASS_NAME = "\\B\\w+(\\.[a-z])";

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        String abrevMarker = ELLIPSIS;
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + abrevMarker;
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + maxWidth - 3 < str.length()) {
            return abrevMarker + Strings.abbreviate(str.substring(offset), 0, maxWidth - 3);
        }
        return abrevMarker + str.substring(str.length() - (maxWidth - 3));
    }

    public static String abbreviateMiddle(String string, int maxLength) {
        if (string == null || maxLength >= string.length()) {
            return string;
        }
        if (maxLength == 0) {
            return EMPTY;
        }
        if (maxLength <= ELLIPSIS.length()) {
            return string.substring(0, maxLength);
        }
        int targetSting = Math.max(1, maxLength - ELLIPSIS.length());
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = string.length() - targetSting / 2;
        return string.substring(0, startOffset) + ELLIPSIS + string.substring(endOffset);
    }

    public static String abbreviateFqClassName(String fqcn) {
        return fqcn.replaceAll(FQ_CLASS_NAME, "$1");
    }

    public static String substringAfterLast(String str, String separator) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        if (com.google.common.base.Strings.isNullOrEmpty((String)separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String strip(String str, String stripChars) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        str = Strings.stripStart(str, stripChars);
        return Strings.stripEnd(str, stripChars);
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String getParent(String path) {
        String result = path;
        if (!com.google.common.base.Strings.isNullOrEmpty((String)path) && !"/".equals(path)) {
            int lastSlash = path.lastIndexOf(47, path.length());
            result = lastSlash != -1 ? (lastSlash == 0 ? path.substring(0, 1) : path.substring(0, lastSlash)) : null;
        }
        return result;
    }

    public static String getDomain(String url) {
        int index;
        String result = url;
        if (!com.google.common.base.Strings.isNullOrEmpty((String)url) && (index = url.indexOf(SCHEME_HOST_SEPARATOR)) != -1) {
            int questionMark;
            int slash = url.substring(index + SCHEME_HOST_SEPARATOR.length()).indexOf(47);
            if (slash != -1) {
                result = url.substring(0, index + slash + SCHEME_HOST_SEPARATOR.length());
            }
            if ((questionMark = url.substring(index + SCHEME_HOST_SEPARATOR.length()).indexOf(63)) != -1) {
                result = url.substring(0, index + questionMark + SCHEME_HOST_SEPARATOR.length());
            }
        }
        return result;
    }

    private Strings() {
    }
}

