/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.hal.modelgraph.dmr.Operation;
import org.jboss.hal.modelgraph.dmr.ResourceAddress;
import org.jboss.hal.modelgraph.dmr.WildFlyClient;
import org.jboss.hal.modelgraph.neo4j.Cypher;
import org.jboss.hal.modelgraph.neo4j.Neo4jClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Analyzer {
    private static final int MAX_DEPTH = 10;
    private static final Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final WildFlyClient wc;
    private final Neo4jClient nc;
    private long[] resources;

    Analyzer(WildFlyClient wc, Neo4jClient nc) {
        this.wc = wc;
        this.nc = nc;
        this.resources = new long[2];
    }

    void start(String resource) {
        this.parse(ResourceAddress.of(resource), null);
    }

    private void parse(ResourceAddress address, ResourceAddress parent) {
        if (address.size() < 10) {
            this.parseResource(address, parent);
            this.readChildren(address).forEach(child -> this.parse(address.add((String)child), address));
        } else {
            logger.warn("Skipping {}. Maximum nesting of {} reached.", (Object)address.toString(), (Object)10);
        }
    }

    private void parseResource(ResourceAddress address, ResourceAddress parent) {
        Operation rrd = new Operation.Builder("read-resource-description", address).param("include-aliases", true).build();
        ModelNode resourceDescription = this.wc.execute(rrd);
        if (resourceDescription.isDefined()) {
            List<ModelNode> descriptions;
            logger.info("Parse {}", (Object)address.toString());
            if (resourceDescription.getType() == ModelType.LIST && !(descriptions = resourceDescription.asList()).isEmpty() && descriptions.get(0).hasDefined("result")) {
                resourceDescription = descriptions.get(0).get("result");
            }
            this.createResource(address);
            if (parent != null) {
                this.mergeChildOf(address, parent);
            }
            if (resourceDescription.hasDefined("capabilities")) {
                resourceDescription.get("capabilities").asList().stream().map(modelNode -> modelNode.get("name").asString()).forEach(capability -> this.mergeCapabilities(address, (String)capability));
            }
            if (resourceDescription.hasDefined("attributes")) {
                ArrayListMultimap alternatives = ArrayListMultimap.create();
                ArrayListMultimap requires = ArrayListMultimap.create();
                resourceDescription.get("attributes").asPropertyList().forEach(property -> {
                    String name = property.getName();
                    ModelNode attribute = property.getValue();
                    this.mergeAttribute(address, name, attribute);
                    if (attribute.hasDefined("alternatives")) {
                        List a = attribute.get("alternatives").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                        alternatives.putAll(name, a);
                    }
                    if (attribute.hasDefined("requires")) {
                        List r = attribute.get("requires").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                        requires.putAll(name, r);
                    }
                });
                alternatives.entries().forEach(entry -> this.mergeAttributeRelation(address, (String)entry.getKey(), (String)entry.getValue(), "-[:ALTERNATIVE]-"));
                requires.entries().forEach(entry -> this.mergeAttributeRelation(address, (String)entry.getKey(), (String)entry.getValue(), "-[:REQUIRES]->"));
            }
            this.resources[1] = this.resources[1] + 1L;
        } else {
            this.resources[0] = this.resources[0] + 1L;
        }
    }

    private List<String> readChildren(ResourceAddress address) {
        Operation rct = new Operation.Builder("read-children-types", address).param("include-singletons", true).build();
        ModelNode result = this.wc.execute(rct);
        if (result.isDefined()) {
            return result.asList().stream().map(ModelNode::asString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void createResource(ResourceAddress address) {
        Cypher cypher = new Cypher("CREATE (:Resource {").append("name", address.getName()).comma().append("address", address.toString()).comma().append("singleton", address.isSingleton()).append("})");
        this.nc.execute(cypher);
    }

    private void mergeChildOf(ResourceAddress child, ResourceAddress parent) {
        Cypher cypher = new Cypher("MATCH (child:Resource {").append("address", "child", child.toString()).append("}),").append("(parent:Resource {").append("address", "parent", parent.toString()).append("})").append(" MERGE (child)-[:CHILD_OF]->(parent)");
        this.nc.execute(cypher);
    }

    private void mergeCapabilities(ResourceAddress address, String capability) {
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("})").append(" MERGE (r)-[:DECLARES_CAPABILITY]->(:Capability {").append("name", capability).append("})");
        this.nc.execute(cypher);
    }

    private void mergeAttribute(ResourceAddress address, String name, ModelNode attribute) {
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("})").append(" MERGE (r)-[:HAS_ATTRIBUTE]->(a:Attribute {").append("name", name);
        this.addIfPresent(cypher, "access-type", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "alias", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "attribute-group", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "default", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "expressions-allowed", attribute, ModelNode::asBoolean);
        this.addIfPresent(cypher, "max", attribute, ModelNode::asLong);
        this.addIfPresent(cypher, "min", attribute, ModelNode::asLong);
        this.addIfPresent(cypher, "nillable", attribute, ModelNode::asBoolean);
        this.addIfPresent(cypher, "required", attribute, ModelNode::asBoolean);
        this.addIfPresent(cypher, "restart-required", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "storage", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "type", attribute, value -> value.asType().name());
        this.addIfPresent(cypher, "unit", attribute, ModelNode::asString);
        if (attribute.hasDefined("deprecated")) {
            cypher.comma().append("deprecated", true);
            ModelNode deprecatedNode = attribute.get("deprecated");
            this.addIfPresent(cypher, "since", deprecatedNode, ModelNode::asString);
        }
        if (attribute.hasDefined("value-type")) {
            ModelNode valueTypeNode = attribute.get("value-type");
            try {
                ModelType valueType = valueTypeNode.asType();
                cypher.comma().append("value-type", valueType.name());
            }
            catch (IllegalArgumentException e) {
                cypher.comma().append("value-type", ModelType.OBJECT.name());
            }
        }
        cypher.append("})");
        if (attribute.hasDefined("capability-reference")) {
            String capabilityReference = attribute.get("capability-reference").asString();
            cypher.append(" MERGE (a)-[:REFERENCES_CAPABILITY]-(:Capability {").append("name", "capability-reference", capabilityReference).append("})");
        }
        this.nc.execute(cypher);
    }

    private void mergeAttributeRelation(ResourceAddress address, String source, String target, String relation) {
        Cypher cypher = new Cypher("MATCH (r1:Resource {").append("address", address.toString()).append("})").append("-[:HAS_ATTRIBUTE]->(source:Attribute {").append("name", "sourceName", source).append("}),").append("(r2:Resource {").append("address", address.toString()).append("})").append("-[:HAS_ATTRIBUTE]->(target:Attribute {").append("name", "targetName", target).append("})").append(" MERGE (source)").append(relation).append("(target)");
        this.nc.execute(cypher);
    }

    private <T> void addIfPresent(Cypher cypher, String name, ModelNode modelNode, Function<ModelNode, T> getValue) {
        if (modelNode.hasDefined(name)) {
            ModelNode value = modelNode.get(name);
            cypher.comma().append(name, getValue.apply(value));
        }
    }

    long getSuccessfulResources() {
        return this.resources[1];
    }

    long getFailedResources() {
        return this.resources[0];
    }
}

