/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.security.sasl.SaslClientFactory;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionBuilder;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.ConnectionKey;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.FutureConnection;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.Version;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.RegisteredService;
import org.jboss.remoting3.spi.SpiUtils;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.sasl.util.PrivilegedSaslClientFactory;
import org.wildfly.security.sasl.util.ProtocolSaslClientFactory;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;
import org.xnio.Bits;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Result;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final Logger log;
    private static final int CLOSED_FLAG = Integer.MIN_VALUE;
    private static final int COUNT_MASK = Integer.MAX_VALUE;
    private static final String FQCN;
    private final Set<ConnectionImpl> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Attachments attachments = new Attachments();
    private final ConcurrentMap<String, ConnectionProvider> connectionProviders = new ConcurrentHashMap<String, ConnectionProvider>();
    private final ConcurrentMap<String, RegisteredServiceImpl> registeredServices = new ConcurrentHashMap<String, RegisteredServiceImpl>();
    private final ConcurrentMap<ConnectionKey, FutureConnection> configuredConnections = new ConcurrentHashMap<ConnectionKey, FutureConnection>();
    private final Xnio xnio;
    private final XnioWorker worker;
    private final Object connectionLock = new Object();
    private static final AtomicIntegerFieldUpdater<EndpointImpl> resourceCountUpdater;
    private volatile int resourceCount = 0;
    private static final Pattern VALID_SERVICE_PATTERN;
    static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT;
    private final String name;
    private final ConnectionProviderContext connectionProviderContext;
    private final CloseHandler<Object> resourceCloseHandler = (closed, exception) -> this.closeTick1(closed);
    private final CloseHandler<Connection> connectionCloseHandler = (closed, exception) -> this.connections.remove(closed);
    private final boolean ourWorker;
    private final SocketAddress defaultBindAddress;

    private EndpointImpl(XnioWorker xnioWorker, boolean ourWorker, String name, SocketAddress defaultBindAddress) throws NotOpenException {
        super(xnioWorker, true);
        this.worker = xnioWorker;
        this.ourWorker = ourWorker;
        this.xnio = xnioWorker.getXnio();
        this.name = name;
        this.defaultBindAddress = defaultBindAddress;
        this.connectionProviderContext = new ConnectionProviderContextImpl();
        log.tracef("Completed open of %s", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EndpointImpl construct(EndpointBuilder endpointBuilder) throws IOException {
        EndpointImpl endpoint;
        String endpointName = endpointBuilder.getEndpointName();
        List<ConnectionBuilder> connectionBuilders = endpointBuilder.getConnectionBuilders();
        List<ConnectionProviderFactoryBuilder> factoryBuilders = endpointBuilder.getConnectionProviderFactoryBuilders();
        XnioWorker xnioWorker = endpointBuilder.getXnioWorker();
        SocketAddress defaultBindAddress = endpointBuilder.getDefaultBindAddress();
        if (xnioWorker == null) {
            Xnio xnio = Xnio.getInstance(EndpointImpl.class.getClassLoader());
            OptionMap.Builder builder = OptionMap.builder();
            OptionMap workerOptions = endpointBuilder.getXnioWorkerOptions();
            if (workerOptions != null) {
                builder.addAll(workerOptions);
            }
            builder.addAll(OptionMap.create(Options.THREAD_DAEMON, Boolean.TRUE));
            OptionMap modifiedOptionMap = builder.set(Options.WORKER_NAME, endpointName == null ? "Remoting (anonymous)" : "Remoting \"" + endpointName + "\"").getMap();
            AtomicReference<EndpointImpl> endpointRef = new AtomicReference<EndpointImpl>();
            xnioWorker = xnio.createWorker(null, modifiedOptionMap, () -> {
                EndpointImpl e = endpointRef.getAndSet(null);
                if (e != null) {
                    e.closeComplete();
                }
            });
            endpoint = new EndpointImpl(xnioWorker, true, endpointName, defaultBindAddress);
            endpointRef.set(endpoint);
        } else {
            endpoint = new EndpointImpl(xnioWorker, false, endpointName, defaultBindAddress);
        }
        boolean ok = false;
        try {
            if (factoryBuilders != null) {
                for (ConnectionProviderFactoryBuilder factoryBuilder : factoryBuilders) {
                    ClassLoader classLoader;
                    String className = factoryBuilder.getClassName();
                    String moduleName = factoryBuilder.getModuleName();
                    if (moduleName != null) {
                        try {
                            classLoader = Module.getCallerModuleLoader().loadModule(moduleName).getClassLoader();
                        }
                        catch (ModuleLoadException e) {
                            throw new IOException("Failed to create endpoint", e);
                        }
                        catch (LinkageError e) {
                            throw new IOException("Failed to create endpoint: JBoss Modules is not present", e);
                        }
                    } else {
                        if (className == null) {
                            throw new IllegalArgumentException("Either class or module name required for connection provider factory");
                        }
                        classLoader = EndpointImpl.class.getClassLoader();
                    }
                    if (className == null) {
                        ServiceLoader<ConnectionProviderFactory> loader = ServiceLoader.load(ConnectionProviderFactory.class, classLoader);
                        for (ConnectionProviderFactory factory : loader) {
                            endpoint.addConnectionProvider(factoryBuilder.getScheme(), factory, OptionMap.EMPTY);
                        }
                        continue;
                    }
                    try {
                        Class<ConnectionProviderFactory> factoryClass = classLoader.loadClass(className).asSubclass(ConnectionProviderFactory.class);
                        ConnectionProviderFactory factory = factoryClass.newInstance();
                        endpoint.addConnectionProvider(factoryBuilder.getScheme(), factory, OptionMap.EMPTY);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to load connection provider factory class '" + className + "'", e);
                    }
                }
            }
            RemoteConnectionProviderFactory remoteConnectionProviderFactory = new RemoteConnectionProviderFactory();
            endpoint.addConnectionProvider("remote", remoteConnectionProviderFactory, OptionMap.create(Options.SSL_ENABLED, Boolean.FALSE));
            endpoint.addConnectionProvider("remote+tls", remoteConnectionProviderFactory, OptionMap.create(Options.SECURE, Boolean.TRUE));
            endpoint.addConnectionProvider("remoting", remoteConnectionProviderFactory, OptionMap.create(Options.SSL_ENABLED, Boolean.TRUE));
            HttpUpgradeConnectionProviderFactory httpUpgradeConnectionProviderFactory = new HttpUpgradeConnectionProviderFactory();
            endpoint.addConnectionProvider("remote+http", httpUpgradeConnectionProviderFactory, OptionMap.create(Options.SSL_ENABLED, Boolean.FALSE));
            endpoint.addConnectionProvider("remote+https", httpUpgradeConnectionProviderFactory, OptionMap.create(Options.SECURE, Boolean.TRUE));
            endpoint.addConnectionProvider("http-remoting", httpUpgradeConnectionProviderFactory, OptionMap.create(Options.SSL_ENABLED, Boolean.FALSE));
            endpoint.addConnectionProvider("https-remoting", httpUpgradeConnectionProviderFactory, OptionMap.create(Options.SECURE, Boolean.TRUE));
            AuthenticationContext captured = AuthenticationContext.captureCurrent();
            AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
            if (connectionBuilders != null) {
                for (ConnectionBuilder connectionBuilder : connectionBuilders) {
                    boolean configureSsl;
                    UnaryOperator<SaslClientFactory> saslClientFactoryOperator = connectionBuilder.getSaslClientFactoryOperator();
                    AuthenticationContext context = connectionBuilder.getAuthenticationContext();
                    if (context == null) {
                        context = captured;
                    }
                    URI uri = connectionBuilder.getUri();
                    boolean immediate = connectionBuilder.isImmediate();
                    OptionMap optionMap = connectionBuilder.getOptions();
                    switch (uri.getScheme()) {
                        case "remote+http": 
                        case "http-remoting": 
                        case "remote": {
                            configureSsl = false;
                            break;
                        }
                        case "remote+https": 
                        case "https-remoting": 
                        case "remote+tls": {
                            configureSsl = true;
                            break;
                        }
                        case "remoting": {
                            configureSsl = optionMap.get(Options.SSL_ENABLED, true);
                            break;
                        }
                        default: {
                            configureSsl = true;
                        }
                    }
                    String abstractType = connectionBuilder.getAbstractType();
                    String abstractTypeAuthority = connectionBuilder.getAbstractTypeAuthority();
                    AuthenticationConfiguration configuration = client.getAuthenticationConfiguration(uri, context, -1, abstractType, abstractTypeAuthority, "connect");
                    SecurityFactory<SSLContext> sslContextFactory = configureSsl ? client.getSSLContextFactory(uri, context, abstractType, abstractTypeAuthority, null) : null;
                    FutureConnection futureConnection = new FutureConnection(endpoint, connectionBuilder.getBindAddress(), uri, immediate, optionMap, configuration, saslClientFactoryOperator, sslContextFactory);
                    if (endpoint.configuredConnections.putIfAbsent(new ConnectionKey(uri.getScheme(), abstractType, abstractTypeAuthority, configuration, sslContextFactory), futureConnection) != null || !immediate) continue;
                    endpoint.getConnection(uri);
                }
            }
            ok = true;
            EndpointImpl endpointImpl = endpoint;
            return endpointImpl;
        }
        finally {
            if (!ok) {
                endpoint.closeAsync();
            }
        }
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Executor getExecutor() {
        return new TrackingExecutor();
    }

    @Override
    protected void closeComplete() {
        super.closeComplete();
    }

    private void closeTick1(Object c) {
        int res = resourceCountUpdater.decrementAndGet(this);
        if (res == Integer.MIN_VALUE) {
            this.finishPhase1();
        } else if ((res & Integer.MIN_VALUE) != 0) {
            if (log.isTraceEnabled()) {
                log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Phase 1 shutdown count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
            }
        } else if (log.isTraceEnabled()) {
            log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Resource closed count %08x of %s (closed %s)", (Object)(res & Integer.MAX_VALUE), (Object)this, c);
        }
    }

    private void finishPhase1() {
        log.tracef("Finished phase 1 shutdown of %s", (Object)this);
        if (this.ourWorker) {
            this.worker.shutdown();
        } else {
            this.closeComplete();
        }
    }

    void resourceUntick(Object opened) throws NotOpenException {
        int old;
        do {
            if (((old = resourceCountUpdater.get(this)) & Integer.MIN_VALUE) == 0) continue;
            throw new NotOpenException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    void executorUntick(Object opened) {
        int old;
        do {
            if ((old = resourceCountUpdater.get(this)) != Integer.MIN_VALUE) continue;
            throw new RejectedExecutionException("Endpoint is not open");
        } while (!resourceCountUpdater.compareAndSet(this, old, old + 1));
        if (log.isTraceEnabled()) {
            log.tracef("Allocated tick to %d of %s (opened %s)", (Object)(old + 1), (Object)this, opened);
        }
    }

    boolean isCloseFlagSet() {
        return Bits.allAreSet(resourceCountUpdater.get(this), Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        Object object = this.connectionLock;
        synchronized (object) {
            int res;
            while (!resourceCountUpdater.compareAndSet(this, res = this.resourceCount, res | Integer.MIN_VALUE)) {
            }
            if (res == 0) {
                this.finishPhase1();
            } else {
                for (Object connection : this.connections.toArray()) {
                    ((ConnectionImpl)connection).closeAsync();
                }
                for (ConnectionProvider connectionProvider : this.connectionProviders.values()) {
                    connectionProvider.closeAsync();
                }
            }
        }
    }

    @Override
    public Registration registerService(String serviceType, final OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
        RegisteredServiceImpl registeredService;
        if (!VALID_SERVICE_PATTERN.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type must match " + VALID_SERVICE_PATTERN);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RemotingPermission.REGISTER_SERVICE);
        }
        if (this.registeredServices.putIfAbsent(serviceType, registeredService = new RegisteredServiceImpl(openListener, optionMap)) != null) {
            throw new ServiceRegistrationException("Service type '" + serviceType + "' is already registered");
        }
        MapRegistration<RegisteredServiceImpl> registration = new MapRegistration<RegisteredServiceImpl>(this.registeredServices, serviceType, registeredService){

            @Override
            protected void closeAction() throws IOException {
                try {
                    openListener.registrationTerminated();
                }
                finally {
                    super.closeAction();
                }
            }
        };
        HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler(registration));
        registration.addCloseHandler((closed, exception) -> key.remove());
        return registration;
    }

    @Override
    public IoFuture<Connection> getConnection(URI destination, String abstractType, String abstractTypeAuthority) {
        Assert.checkNotNullParam("destination", destination);
        AuthenticationContext context = AuthenticationContext.captureCurrent();
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        AuthenticationConfiguration configuration = client.getAuthenticationConfiguration(destination, context, -1, abstractType, abstractTypeAuthority, "connect");
        SecurityFactory<SSLContext> sslContextFactory = client.getSSLContextFactory(destination, context, abstractType, abstractTypeAuthority, null);
        String scheme = destination.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("No scheme given in URI '" + destination + "'");
        }
        String host = client.getRealHost(configuration);
        if (host == null) {
            throw new IllegalArgumentException("No host given in URI '" + destination + "'");
        }
        Principal principal = client.getPrincipal(configuration);
        int port = client.getRealPort(configuration);
        ConnectionKey connectionKey = new ConnectionKey(scheme, abstractType, abstractTypeAuthority, configuration, sslContextFactory);
        FutureConnection futureConnection = (FutureConnection)this.configuredConnections.get(connectionKey);
        if (futureConnection != null) {
            return futureConnection.get();
        }
        futureConnection = new FutureConnection(this, null, destination, false, OptionMap.EMPTY, configuration, UnaryOperator.identity(), sslContextFactory);
        FutureConnection appearing = this.configuredConnections.putIfAbsent(connectionKey, futureConnection);
        if (appearing != null) {
            return appearing.get();
        }
        return futureConnection.get();
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions) throws IOException {
        return this.connect(destination, connectOptions, AuthenticationContext.captureCurrent());
    }

    @Override
    public IoFuture<Connection> connect(URI destination, OptionMap connectOptions, AuthenticationContext authenticationContext) throws IOException {
        return this.connect(destination, null, connectOptions, authenticationContext);
    }

    @Override
    public IoFuture<Connection> connect(URI destination, InetSocketAddress bindAddress, OptionMap connectOptions, AuthenticationContext authenticationContext) throws IOException {
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        AuthenticationConfiguration configuration = client.getAuthenticationConfiguration(destination, authenticationContext, -1, null, null, "connect");
        SecurityFactory<SSLContext> sslContextFactory = client.getSSLContextFactory(destination, authenticationContext, null, null, null);
        return this.connect(destination, bindAddress, connectOptions, configuration, UnaryOperator.identity(), sslContextFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IoFuture<Connection> connect(final URI destination, SocketAddress bindAddress, OptionMap connectOptions, final AuthenticationConfiguration configuration, UnaryOperator<SaslClientFactory> saslClientFactoryOperator, SecurityFactory<SSLContext> sslContextFactory) throws UnknownURISchemeException, NotOpenException {
        Assert.checkNotNullParam("destination", destination);
        Assert.checkNotNullParam("connectOptions", connectOptions);
        String protocol = connectOptions.contains(RemotingOptions.SASL_PROTOCOL) ? connectOptions.get(RemotingOptions.SASL_PROTOCOL) : "remote";
        UnaryOperator<SaslClientFactory> factoryOperator = factory -> new PrivilegedSaslClientFactory((SaslClientFactory)factory);
        factoryOperator = EndpointImpl.and(factoryOperator, factory -> new ProtocolSaslClientFactory((SaslClientFactory)factory, protocol));
        if (connectOptions.contains(RemotingOptions.SERVER_NAME)) {
            String serverName = connectOptions.get(RemotingOptions.SERVER_NAME);
            factoryOperator = EndpointImpl.and(factoryOperator, factory -> new ServerNameSaslClientFactory((SaslClientFactory)factory, serverName));
        }
        factoryOperator = EndpointImpl.and(factoryOperator, saslClientFactoryOperator);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RemotingPermission.CONNECT);
        }
        String scheme = destination.getScheme();
        Object object = this.connectionLock;
        synchronized (object) {
            IoFuture<Connection> ioFuture;
            block10: {
                boolean ok = false;
                this.resourceUntick("Connection to " + destination);
                try {
                    ConnectionProvider connectionProvider = (ConnectionProvider)this.connectionProviders.get(scheme);
                    if (connectionProvider == null) {
                        throw new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed");
                    }
                    final FutureResult futureResult = new FutureResult(this.getExecutor());
                    final StackTraceElement[] mark = Thread.currentThread().getStackTrace();
                    final Principal principal = AUTH_CONFIGURATION_CLIENT.getPrincipal(configuration);
                    final UnaryOperator<SaslClientFactory> finalFactoryOperator = factoryOperator;
                    Result<ConnectionHandlerFactory> result = new Result<ConnectionHandlerFactory>(){
                        private final AtomicBoolean flag = new AtomicBoolean();

                        @Override
                        public boolean setCancelled() {
                            if (!this.flag.compareAndSet(false, true)) {
                                return false;
                            }
                            log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)null, "Registered cancellation result", new Object[0]);
                            EndpointImpl.this.closeTick1("a cancelled connection");
                            futureResult.setCancelled();
                            return true;
                        }

                        @Override
                        public boolean setException(IOException exception) {
                            if (!this.flag.compareAndSet(false, true)) {
                                return false;
                            }
                            log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)exception, "Registered exception result", new Object[0]);
                            EndpointImpl.this.closeTick1("a failed connection (2)");
                            SpiUtils.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                            futureResult.setException(exception);
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean setResult(ConnectionHandlerFactory connHandlerFactory) {
                            if (!this.flag.compareAndSet(false, true)) {
                                return false;
                            }
                            Object object = EndpointImpl.this.connectionLock;
                            synchronized (object) {
                                log.logf(this.getClass().getName(), Logger.Level.TRACE, (Throwable)null, "Registered successful result %s", (Object)connHandlerFactory);
                                ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connHandlerFactory, EndpointImpl.this.connectionProviderContext, destination, principal, finalFactoryOperator, null, configuration);
                                EndpointImpl.this.connections.add(connection);
                                connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                                connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                                connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                                if (EndpointImpl.this.isCloseFlagSet()) {
                                    connection.closeAsync();
                                    futureResult.setCancelled();
                                } else {
                                    futureResult.setResult(connection);
                                }
                            }
                            return true;
                        }
                    };
                    Cancellable connect = connectionProvider.connect(destination, bindAddress, connectOptions, result, configuration, sslContextFactory, finalFactoryOperator, Collections.emptyList());
                    ok = true;
                    futureResult.addCancelHandler(connect);
                    ioFuture = futureResult.getIoFuture();
                    if (ok) break block10;
                    this.closeTick1("a failed connection (1)");
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        this.closeTick1("a failed connection (1)");
                    }
                    throw throwable;
                }
            }
            return ioFuture;
        }
    }

    private static <T> UnaryOperator<T> and(UnaryOperator<T> first, UnaryOperator<T> second) {
        return t -> second.apply(first.apply(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory, OptionMap optionMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RemotingPermission.ADD_CONNECTION_PROVIDER);
        }
        boolean ok = false;
        this.resourceUntick("Connection provider for " + uriScheme);
        try {
            MapRegistration<ConnectionProvider> mapRegistration;
            block10: {
                ConnectionProviderContextImpl context = new ConnectionProviderContextImpl();
                final ConnectionProvider provider = providerFactory.createInstance(context, optionMap);
                try {
                    if (this.connectionProviders.putIfAbsent(uriScheme, provider) != null) {
                        throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
                    }
                    log.tracef("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
                    MapRegistration<ConnectionProvider> registration = new MapRegistration<ConnectionProvider>(this.connectionProviders, uriScheme, provider){

                        @Override
                        protected void closeAction() throws IOException {
                            try {
                                provider.closeAsync();
                            }
                            finally {
                                super.closeAction();
                            }
                        }
                    };
                    provider.addCloseHandler((closed, exception) -> {
                        registration.closeAsync();
                        this.closeTick1(closed);
                    });
                    ok = true;
                    mapRegistration = registration;
                    if (ok) break block10;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        provider.close();
                    }
                    throw throwable;
                }
                provider.close();
            }
            return mapRegistration;
        }
        finally {
            if (!ok) {
                this.closeTick1("Connection provider for " + uriScheme);
            }
        }
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RemotingPermission.GET_CONNECTION_PROVIDER_INTERFACE);
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ConnectionProvider provider = (ConnectionProvider)this.connectionProviders.get(uriScheme);
        if (provider == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(provider.getProviderInterface());
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.connectionProviders.containsKey(uriScheme);
    }

    @Override
    public XnioWorker getXnioWorker() {
        return this.worker;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("endpoint ");
        if (this.name != null) {
            b.append('\"').append(this.name).append('\"');
        } else {
            b.append("(anonymous)");
        }
        b.append(" <").append(Integer.toHexString(this.hashCode())).append(">");
        return b.toString();
    }

    static {
        Logger.getLogger("org.jboss.remoting").infof("JBoss Remoting version %s", (Object)Version.getVersionString());
        log = Logger.getLogger("org.jboss.remoting.endpoint");
        FQCN = EndpointImpl.class.getName();
        resourceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EndpointImpl.class, "resourceCount");
        VALID_SERVICE_PATTERN = Pattern.compile("[-.:a-zA-Z_0-9]+");
        AUTH_CONFIGURATION_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    }

    final class TrackingExecutor
    implements Executor {
        private final AtomicInteger count = new AtomicInteger();

        TrackingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            AtomicInteger count = this.count;
            int i = count.getAndIncrement();
            boolean ok = false;
            try {
                if (i == 0) {
                    EndpointImpl.this.executorUntick(this);
                }
                EndpointImpl.this.worker.execute(() -> {
                    try {
                        command.run();
                    }
                    finally {
                        this.finishWork();
                    }
                });
                ok = true;
            }
            finally {
                if (!ok) {
                    this.finishWork();
                }
            }
        }

        void finishWork() {
            if (this.count.decrementAndGet() == 0) {
                EndpointImpl.this.closeTick1(this);
            }
        }
    }

    private static class RegisteredServiceImpl
    implements RegisteredService {
        private final OpenListener openListener;
        private final OptionMap optionMap;

        private RegisteredServiceImpl(OpenListener openListener, OptionMap optionMap) {
            this.openListener = openListener;
            this.optionMap = optionMap;
        }

        @Override
        public OpenListener getOpenListener() {
            return this.openListener;
        }

        @Override
        public OptionMap getOptionMap() {
            return this.optionMap;
        }
    }

    private final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private ConnectionProviderContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory, SaslAuthenticationFactory authenticationFactory) {
            Object object = EndpointImpl.this.connectionLock;
            synchronized (object) {
                try {
                    EndpointImpl.this.resourceUntick("an inbound connection");
                }
                catch (NotOpenException e) {
                    throw new IllegalStateException("Accept after endpoint close", e);
                }
                boolean ok = false;
                try {
                    ConnectionImpl connection = new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this, null, AnonymousPrincipal.getInstance(), UnaryOperator.identity(), authenticationFactory, AuthenticationConfiguration.EMPTY);
                    EndpointImpl.this.connections.add(connection);
                    connection.getConnectionHandler().addCloseHandler(SpiUtils.asyncClosingCloseHandler(connection));
                    connection.addCloseHandler(EndpointImpl.this.connectionCloseHandler);
                    connection.addCloseHandler(EndpointImpl.this.resourceCloseHandler);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        EndpointImpl.this.closeTick1("a failed inbound connection");
                    }
                }
            }
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }

        @Override
        public Xnio getXnio() {
            return EndpointImpl.this.xnio;
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.getExecutor();
        }

        @Override
        public XnioWorker getXnioWorker() {
            return EndpointImpl.this.worker;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final ConnectionImpl connection;
        private final IntIndexHashMap<ConnectionImpl.Auth> authMap = new IntIndexHashMap<ConnectionImpl.Auth>(ConnectionImpl.Auth::getId);

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, ConnectionImpl connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        @Override
        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        @Override
        public RegisteredServiceImpl getRegisteredService(String serviceType) {
            return (RegisteredServiceImpl)EndpointImpl.this.registeredServices.get(serviceType);
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void remoteClosed() {
            this.connection.closeAsync();
        }

        @Override
        public void receiveAuthRequest(int id, String mechName, byte[] initialResponse) {
            this.connection.receiveAuthRequest(id, mechName, initialResponse);
        }

        @Override
        public void receiveAuthResponse(int id, byte[] response) {
            this.connection.receiveAuthResponse(id, response);
        }

        @Override
        public void receiveAuthDelete(int id) {
            this.connection.receiveAuthDelete(id);
        }

        @Override
        public void receiveAuthChallenge(int id, byte[] challenge) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveChallenge(id, challenge);
        }

        @Override
        public void receiveAuthSuccess(int id, byte[] challenge) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveSuccess(id, challenge);
        }

        @Override
        public void receiveAuthReject(int id) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveReject(id);
        }

        @Override
        public void receiveAuthDeleteAck(int id) {
            if (id == 0 || id == 1) {
                return;
            }
            this.connection.getPeerIdentityContext().receiveDeleteAck(id);
        }
    }

    private class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        private MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super(EndpointImpl.this.getExecutor(), false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() throws IOException {
            this.map.remove(this.key, this.value);
            this.closeComplete();
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }
}

