/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.Logger;

public class LoggingByteChannel
implements ByteChannel {
    private final ByteChannel delegate;
    private final Logger logger;

    public LoggingByteChannel(ByteChannel delegate, Logger logger2) throws IOException {
        this.delegate = delegate;
        this.logger = logger2;
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        int offset = buf.position();
        int length = this.delegate.write(buf);
        this.logger.trace("C: " + BytePrinter.hexInOneLine(buf, offset, length), new Object[0]);
        return length;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        int offset = buf.position();
        int length = this.delegate.read(buf);
        this.logger.trace("S: " + BytePrinter.hexInOneLine(buf, offset, length), new Object[0]);
        return length;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

