/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.Credential;

public interface AlgorithmCredential
extends Credential {
    public String getAlgorithm();

    default public AlgorithmParameterSpec getParameters() {
        return this.getParameters(AlgorithmParameterSpec.class);
    }

    default public <P extends AlgorithmParameterSpec> P getParameters(Class<P> paramSpecClass) {
        Assert.checkNotNullParam("paramSpecClass", paramSpecClass);
        return null;
    }

    default public boolean supportsParameters() {
        return this.supportsParameters(AlgorithmParameterSpec.class);
    }

    default public boolean supportsParameters(Class<? extends AlgorithmParameterSpec> paramSpecClass) {
        return false;
    }

    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("parameterSpec", parameterSpec);
        return false;
    }

    default public boolean impliesSameParameters(AlgorithmCredential other) {
        Assert.checkNotNullParam("other", other);
        AlgorithmParameterSpec parameters = other.getParameters();
        return parameters == null ? !this.supportsParameters() : this.impliesParameters(parameters);
    }

    @Override
    public AlgorithmCredential clone();

    @Override
    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
        return !(!credentialType.isInstance(this) || algorithmName != null && !algorithmName.equals(this.getAlgorithm()) || parameterSpec != null && !this.impliesParameters(parameterSpec)) ? (R)function.apply(credentialType.cast(this)) : null;
    }

    @Override
    default public <C extends Credential, R> R castAndApply(Class<C> credentialType, String algorithmName, Function<C, R> function) {
        return credentialType.isInstance(this) && (algorithmName == null || algorithmName.equals(this.getAlgorithm())) ? (R)function.apply(credentialType.cast(this)) : null;
    }

    @Override
    default public boolean matches(Credential other) {
        return other instanceof AlgorithmCredential && this.matches((AlgorithmCredential)other);
    }

    @Override
    default public boolean matches(AlgorithmCredential other) {
        return other != null && other.getClass() == this.getClass() && this.getAlgorithm().equals(other.getAlgorithm()) && this.impliesSameParameters(other);
    }
}

