/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph.neo4j;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public class Cypher {
    private final StringBuilder builder;
    private final Map<String, Value> parameters;

    public Cypher(String cypher) {
        this.builder = new StringBuilder(cypher);
        this.parameters = new HashMap<String, Value>();
    }

    public Cypher comma() {
        this.builder.append(", ");
        return this;
    }

    public Cypher append(String cypher) {
        this.builder.append(cypher);
        return this;
    }

    public <T> Cypher append(String name, T value) {
        return this.append(name, name, value);
    }

    public <T> Cypher append(String attribute, String placeholder, T value) {
        String safePlaceHolder = placeholder.replace('-', '_');
        if (attribute.contains("-")) {
            this.builder.append("`");
        }
        this.builder.append(attribute);
        if (attribute.contains("-")) {
            this.builder.append("`");
        }
        this.builder.append(": {").append(safePlaceHolder).append("}");
        this.parameters.put(safePlaceHolder, Values.value(value));
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    String statement() {
        return this.builder.toString();
    }

    Value parameters() {
        return Values.value(this.parameters);
    }
}

