/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph.neo4j;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import org.jboss.hal.modelgraph.neo4j.Cypher;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jClient.class);
    private final Driver driver;
    private final String webInterface;
    private long nodesCreated;
    private long relationsCreated;

    public Neo4jClient(HostAndPort hostAndPort, String username, String password) throws IOException {
        String uri = "bolt://" + hostAndPort;
        this.driver = GraphDatabase.driver(uri, AuthTokens.basic(username, password));
        this.webInterface = "http://" + hostAndPort.getHost() + ":7474/browser/";
        logger.info("Connected to Neo4j database at {}", (Object)hostAndPort);
        this.createIndex();
    }

    private void createIndex() {
    }

    public void execute(Cypher cypher) {
        try (Session session = this.driver.session();
             Transaction tx = session.beginTransaction();){
            logger.debug("Execute {} using {}", (Object)cypher.statement(), (Object)cypher.parameters());
            StatementResult result = tx.run(cypher.statement(), cypher.parameters());
            tx.success();
            logger.debug("{} node and {} relations created", (Object)result.summary().counters().nodesCreated(), (Object)result.summary().counters().relationshipsCreated());
            this.nodesCreated += (long)result.summary().counters().nodesCreated();
            this.relationsCreated += (long)result.summary().counters().relationshipsCreated();
        }
    }

    @Override
    public void close() throws Exception {
        logger.debug("Closing connection to Neo4j database");
        this.driver.close();
    }

    public String getWebInterface() {
        return this.webInterface;
    }

    public long getNodesCreated() {
        return this.nodesCreated;
    }

    public long getRelationsCreated() {
        return this.relationsCreated;
    }
}

