/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.Module;
import org.jboss.modules.NamedClassLoader;

public abstract class ConcurrentClassLoader
extends NamedClassLoader {
    private static final ThreadLocal<Boolean> GET_PACKAGE_SUPPRESSOR = new ThreadLocal();
    protected static final Enumeration<URL> EMPTY_ENUMERATION;
    private final ConcurrentHashMap<String, Package> packages = new ConcurrentHashMap();

    protected ConcurrentClassLoader(ConcurrentClassLoader parent) {
        this(parent, null);
    }

    protected ConcurrentClassLoader() {
        this((String)null);
    }

    protected ConcurrentClassLoader(ConcurrentClassLoader parent, String name) {
        super(parent == null ? JDKSpecific.getPlatformClassLoader() : parent, name);
        if (!JDKSpecific.isParallelCapable(this)) {
            throw new Error("Cannot instantiate non-parallel subclass");
        }
    }

    protected ConcurrentClassLoader(String name) {
        super(JDKSpecific.getPlatformClassLoader(), name);
        if (!JDKSpecific.isParallelCapable(this)) {
            throw new Error("Cannot instantiate non-parallel subclass");
        }
    }

    static Object getLockForClass(ConcurrentClassLoader cl, String name) {
        return cl.getClassLoadingLock(name);
    }

    @Override
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, false, false);
    }

    @Override
    public final Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, false, resolve);
    }

    public final Class<?> loadExportedClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, true, false);
    }

    public final Class<?> loadExportedClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, true, resolve);
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        throw new ClassNotFoundException(className);
    }

    protected final Class<?> defineOrLoadClass(String className, byte[] bytes, int off, int len) {
        try {
            Class<?> definedClass = this.defineClass(className, bytes, off, len);
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            throw e;
        }
    }

    protected final Class<?> defineOrLoadClass(String className, byte[] bytes, int off, int len, ProtectionDomain protectionDomain) {
        try {
            Class<?> definedClass = this.defineClass(className, bytes, off, len, protectionDomain);
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            throw e;
        }
    }

    @Override
    protected final Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false, false);
    }

    @Override
    protected final Class<?> findClass(String moduleName, String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public final URL getResource(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return JDKSpecific.getSystemResource(name);
        }
        return this.findResource(name, false);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return JDKSpecific.getSystemResources(name);
        }
        return this.findResources(name, false);
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return null;
    }

    @Override
    protected final URL findResource(String name) {
        return null;
    }

    @Override
    protected final URL findResource(String moduleName, String name) throws IOException {
        return this.getResource(name);
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return EMPTY_ENUMERATION;
    }

    @Override
    protected final Enumeration<URL> findResources(String name) {
        return EMPTY_ENUMERATION;
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        URL url = this.findResource(name, exportsOnly);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return JDKSpecific.getSystemResourceAsStream(name);
        }
        return this.findResourceAsStream(name, false);
    }

    private Class<?> performLoadClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (className.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        for (String s : Module.systemPackages) {
            if (!className.startsWith(s)) continue;
            return JDKSpecific.getSystemClass(this, className);
        }
        return this.performLoadClassUnchecked(className, exportsOnly, resolve);
    }

    private Class<?> performLoadClassUnchecked(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className.charAt(0) == '[') {
            Class<?> array = Class.forName(className, false, this);
            if (resolve) {
                this.resolveClass(array);
            }
            return array;
        }
        return this.findClass(className, exportsOnly, resolve);
    }

    Class<?> findSystemClassInternal(String name) throws ClassNotFoundException {
        return this.findSystemClass(name);
    }

    @Override
    protected final Package getPackage(String name) {
        String packageName = name + ".";
        for (String s : Module.systemPackages) {
            if (!packageName.startsWith(s)) continue;
            return Package.getPackage(name);
        }
        if (GET_PACKAGE_SUPPRESSOR.get() == Boolean.TRUE) {
            return null;
        }
        return this.getPackageByName(name);
    }

    protected Package getPackageByName(String name) {
        Package parentPackage = super.getPackage(name);
        return parentPackage == null ? this.findLoadedPackage(name) : parentPackage;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> list = new ArrayList<Package>();
        list.addAll(this.packages.values());
        list.addAll(Arrays.asList(super.getPackages()));
        return list.toArray(new Package[list.size()]);
    }

    protected final Package findLoadedPackage(String name) {
        return this.packages.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        ThreadLocal<Boolean> suppressor = GET_PACKAGE_SUPPRESSOR;
        suppressor.set(Boolean.TRUE);
        try {
            Package pkg;
            Package existing;
            block7: {
                existing = this.packages.get(name);
                if (existing != null) {
                    Package package_ = existing;
                    return package_;
                }
                try {
                    pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                }
                catch (IllegalArgumentException iae) {
                    pkg = super.getPackage(name);
                    if (pkg != null) break block7;
                    throw iae;
                }
            }
            existing = this.packages.putIfAbsent(name, pkg);
            Package package_ = existing != null ? existing : pkg;
            return package_;
        }
        finally {
            suppressor.remove();
        }
    }

    static {
        if (!ClassLoader.registerAsParallelCapable()) {
            throw new Error("Failed to register " + ConcurrentClassLoader.class.getName() + " as parallel-capable");
        }
        Package.getPackages();
        EMPTY_ENUMERATION = Collections.enumeration(Collections.emptySet());
    }
}

