/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import org.jboss.remoting3.Attachable;
import org.jboss.remoting3.ConfigurationEndpointSupplier;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.EndpointGetterHolder;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public interface Endpoint
extends HandleableCloseable<Endpoint>,
Attachable,
Contextual<Endpoint> {
    public static final ContextManager<Endpoint> ENDPOINT_CONTEXT_MANAGER = AccessController.doPrivileged(() -> {
        ContextManager<Endpoint> contextManager = new ContextManager<Endpoint>(Endpoint.class, "jboss-remoting.endpoint");
        contextManager.setGlobalDefaultSupplierIfNotSet(ConfigurationEndpointSupplier::new);
        return contextManager;
    });

    @Override
    default public ContextManager<Endpoint> getInstanceContextManager() {
        return EndpointImpl.ENDPOINT_CONTEXT_MANAGER;
    }

    public static Endpoint getCurrent() {
        return EndpointGetterHolder.SUPPLIER.get();
    }

    public String getName();

    public Registration registerService(String var1, OpenListener var2, OptionMap var3) throws ServiceRegistrationException;

    default public IoFuture<Connection> getConnection(URI destination) {
        return this.getConnection(destination, null, null);
    }

    public IoFuture<Connection> getConnection(URI var1, String var2, String var3);

    default public IoFuture<Connection> connect(URI destination) throws IOException {
        return this.connect(destination, OptionMap.EMPTY);
    }

    public IoFuture<Connection> connect(URI var1, OptionMap var2) throws IOException;

    public IoFuture<Connection> connect(URI var1, OptionMap var2, AuthenticationContext var3) throws IOException;

    public IoFuture<Connection> connect(URI var1, InetSocketAddress var2, OptionMap var3, AuthenticationContext var4) throws IOException;

    public Registration addConnectionProvider(String var1, ConnectionProviderFactory var2, OptionMap var3) throws DuplicateRegistrationException, IOException;

    public <T> T getConnectionProviderInterface(String var1, Class<T> var2) throws UnknownURISchemeException, ClassCastException;

    public boolean isValidUriScheme(String var1);

    public XnioWorker getXnioWorker();

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }
}

