/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import org.jboss.remoting3.ChannelClosedException;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.util.Invocation;
import org.xnio.IoUtils;

public class BlockingInvocation
extends Invocation {
    private final ArrayDeque<Response> responses = new ArrayDeque(2);
    private boolean cancelled;

    public BlockingInvocation(int index) {
        super(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponse() throws InterruptedException {
        ArrayDeque<Response> responses;
        ArrayDeque<Response> arrayDeque = responses = this.responses;
        synchronized (arrayDeque) {
            if (this.cancelled) {
                throw new IllegalStateException("Waiting on cancelled response");
            }
            while (responses.isEmpty()) {
                responses.wait();
            }
            return responses.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(int parameter, MessageInputStream inputStream) {
        ArrayDeque<Response> responses;
        ArrayDeque<Response> arrayDeque = responses = this.responses;
        synchronized (arrayDeque) {
            if (this.cancelled) {
                IoUtils.safeClose((Closeable)inputStream);
                return;
            }
            responses.add(new Response(inputStream, parameter));
            responses.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClosed() {
        ArrayDeque<Response> responses;
        ArrayDeque<Response> arrayDeque = responses = this.responses;
        synchronized (arrayDeque) {
            responses.add(new Response(null, 0));
            responses.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ArrayDeque<Response> responses;
        ArrayDeque<Response> arrayDeque = responses = this.responses;
        synchronized (arrayDeque) {
            while (!responses.isEmpty()) {
                IoUtils.safeClose((Closeable)responses.poll());
            }
            this.cancelled = true;
            responses.notifyAll();
        }
    }

    public final class Response
    implements Closeable {
        private final MessageInputStream inputStream;
        private final int parameter;

        Response(MessageInputStream inputStream, int parameter) {
            this.inputStream = inputStream;
            this.parameter = parameter;
        }

        public MessageInputStream getInputStream() throws IOException {
            MessageInputStream inputStream = this.inputStream;
            if (inputStream == null) {
                throw new ChannelClosedException("Channel was closed");
            }
            return inputStream;
        }

        public int getParameter() {
            return this.parameter;
        }

        @Override
        public void close() throws IOException {
            MessageInputStream inputStream = this.inputStream;
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

