/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawOneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;

public interface OneTimePassword
extends OneWayPassword {
    public static final String ALGORITHM_OTP_MD5 = "otp-md5";
    public static final String ALGORITHM_OTP_SHA1 = "otp-sha1";
    public static final int OTP_HASH_SIZE = 8;

    public byte[] getHash();

    public byte[] getSeed();

    public int getSequenceNumber();

    @Override
    default public OneTimePasswordAlgorithmSpec getParameterSpec() {
        return new OneTimePasswordAlgorithmSpec(this.getAlgorithm(), this.getSeed(), this.getSequenceNumber());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("parameterSpec", parameterSpec);
        return parameterSpec.equals(this.getParameterSpec());
    }

    @Override
    public OneTimePassword clone();

    public static OneTimePassword createRaw(String algorithm, byte[] hash, byte[] seed, int sequenceNumber) {
        Assert.checkNotNullParam("hash", hash);
        Assert.checkNotNullParam("seed", seed);
        Assert.checkNotNullParam("algorithm", algorithm);
        return new RawOneTimePassword(algorithm, (byte[])hash.clone(), (byte[])seed.clone(), sequenceNumber);
    }
}

