/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.wildfly.security.util._private.Arrays2;

public class ServiceLoaderSupplier<E>
implements Supplier<E[]> {
    private final Class<E> service;
    private final ClassLoader classLoader;
    private volatile E[] result;

    public ServiceLoaderSupplier(Class<E> service, ClassLoader classLoader) {
        this.service = service;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E[] get() {
        if (this.result == null) {
            ServiceLoaderSupplier serviceLoaderSupplier = this;
            synchronized (serviceLoaderSupplier) {
                if (this.result == null) {
                    ArrayList<E> list = new ArrayList<E>();
                    ServiceLoader<E> loader = ServiceLoader.load(this.service, this.classLoader);
                    Iterator<E> iterator = loader.iterator();
                    while (true) {
                        try {
                            while (true) {
                                if (!iterator.hasNext()) {
                                    this.result = list.toArray(Arrays2.createArray(this.service, list.size()));
                                    return (Object[])this.result.clone();
                                }
                                list.add(iterator.next());
                            }
                        }
                        catch (ServiceConfigurationError serviceConfigurationError) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return (Object[])this.result.clone();
    }
}

