/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.net.HostAndPort;
import org.jboss.hal.modelgraph.Analyzer;
import org.jboss.hal.modelgraph.HostAndPortConverter;
import org.jboss.hal.modelgraph.HostAndPortValidator;
import org.jboss.hal.modelgraph.dmr.WildFlyClient;
import org.jboss.hal.modelgraph.neo4j.Neo4jClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    @Parameter(names={"-wildfly"}, converter=HostAndPortConverter.class, validateWith=HostAndPortValidator.class, description="WildFly instance as <server>[:<port>] with 9990 as default port. Omit to connect to a local WildFly instance at localhost:9990.")
    private HostAndPort wildFly;
    @Parameter(names={"-wildfly-user"}, description="WildFly username")
    private String wildFlyUsername = "admin";
    @Parameter(names={"-wildfly-password"}, description="WildFly password")
    private String wildFlyPassword = "admin";
    @Parameter(names={"-neo4j"}, converter=HostAndPortConverter.class, validateWith=HostAndPortValidator.class, description="Neo4j database as <server>[:<port>] with 7687 as default port. Omit to connect to a local Neo4j database at localhost:7687.")
    private HostAndPort neo4j;
    @Parameter(names={"-neo4j-user"}, description="Neo4j username")
    private String neo4jUsername = "neo4j";
    @Parameter(names={"-neo4j-password"}, description="Neo4j password")
    private String neo4jPassword = "neo4j";
    @Parameter(names={"-clean"}, description="Removes all indexes, nodes, relationships and properties before analysing the model tree.")
    private boolean clean = false;
    @Parameter(names={"-resource"}, description="The root resource to analyse.")
    private String resource = "/";
    @Parameter(names={"-help", "--help"}, help=true, description="Shows this help")
    private boolean help;

    public static void main(String[] args) {
        Main main = new Main();
        JCommander jCommander = new JCommander((Object)main, args);
        if (main.help) {
            jCommander.usage();
        } else {
            main.run();
        }
    }

    private void run() {
        try (WildFlyClient wc = new WildFlyClient(this.safeHostAndPort(this.wildFly, 9990), this.wildFlyUsername, this.wildFlyPassword);
             Neo4jClient nc = new Neo4jClient(this.safeHostAndPort(this.neo4j, 7687), this.neo4jUsername, this.neo4jPassword, this.clean);){
            Analyzer analyzer = new Analyzer(wc, nc);
            analyzer.start(this.resource);
            this.finished(analyzer, nc);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private HostAndPort safeHostAndPort(HostAndPort hostAndPort, int defaultPort) {
        HostAndPort safe = hostAndPort == null ? HostAndPort.fromParts("localhost", defaultPort) : (!hostAndPort.hasPort() ? HostAndPort.fromParts(hostAndPort.getHost(), defaultPort) : hostAndPort);
        return safe;
    }

    private void finished(Analyzer analyzer, Neo4jClient nc) {
        logger.info("{}", (Object)analyzer.stats());
        logger.info("Use the web interface at {} to query the database.", (Object)nc.getWebInterface());
    }
}

