/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph.dmr;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.hal.modelgraph.dmr.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildFlyClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(WildFlyClient.class);
    private final ModelControllerClient mcc;

    public WildFlyClient(HostAndPort hostAndPort, String username, String password) throws UnknownHostException {
        this.mcc = ModelControllerClient.Factory.create(InetAddress.getByName(hostAndPort.getHost()), hostAndPort.getPort(), callbacks -> {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(password.toCharArray());
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    rcb.setText(rcb.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        });
        logger.info("Connected to WildFly instance at {}", (Object)hostAndPort);
    }

    public ModelNode execute(Operation operation) {
        ModelNode result = new ModelNode();
        try {
            ModelNode modelNode = this.mcc.execute(operation);
            if (modelNode.hasDefined("outcome")) {
                String outcome = modelNode.get("outcome").asString();
                if ("success".equals(outcome)) {
                    if (modelNode.hasDefined("result")) {
                        result = modelNode.get("result");
                    }
                } else if ("failed".equals(outcome)) {
                    if (modelNode.hasDefined("failure-description")) {
                        String error = modelNode.get("failure-description").asString();
                        logger.error("Unable to execute {}: {}", (Object)operation.asCli(), (Object)error);
                    }
                } else {
                    logger.error("Unable to execute {}: Unknown outcome {}", (Object)operation.asCli(), (Object)outcome);
                }
            } else {
                logger.error("Unable to execute {}: No outcome", (Object)operation.asCli());
            }
        }
        catch (IOException e) {
            logger.error("Unable to execute {}: {}", (Object)operation.asCli(), (Object)e.getMessage());
        }
        return result;
    }

    @Override
    public void close() throws Exception {
        logger.debug("Closing connection to WildFly instance");
        this.mcc.close();
    }
}

