/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.net.SocketFactory;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.realm.ldap.DelegatingLdapContext;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.ThreadLocalSSLSocketFactory;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class SimpleDirContextFactoryBuilder {
    private static final String CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private boolean built = false;
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String providerUrl = null;
    private String securityAuthentication = "simple";
    private String securityPrincipal = null;
    private String securityCredential = null;
    private CredentialSource credentialSource = null;
    private SocketFactory socketFactory = null;
    private Properties connectionProperties;
    private int connectTimeout = 5000;
    private int readTimeout = 60000;

    private SimpleDirContextFactoryBuilder() {
    }

    public static SimpleDirContextFactoryBuilder builder() {
        return new SimpleDirContextFactoryBuilder();
    }

    public SimpleDirContextFactoryBuilder setInitialContextFactory(String initialContextFactory) {
        this.assertNotBuilt();
        this.initialContextFactory = initialContextFactory;
        return this;
    }

    public SimpleDirContextFactoryBuilder setProviderUrl(String providerUrl) {
        this.assertNotBuilt();
        this.providerUrl = providerUrl;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSecurityAuthentication(String securityAuthentication) {
        this.assertNotBuilt();
        this.securityAuthentication = securityAuthentication;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSecurityPrincipal(String securityPrincipal) {
        this.assertNotBuilt();
        this.securityPrincipal = securityPrincipal;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSecurityCredential(String securityCredential) {
        this.assertNotBuilt();
        this.securityCredential = securityCredential;
        return this;
    }

    public SimpleDirContextFactoryBuilder setCredentialSource(CredentialSource credentialSource) {
        this.assertNotBuilt();
        this.credentialSource = credentialSource;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSocketFactory(SocketFactory socketFactory) {
        this.assertNotBuilt();
        this.socketFactory = socketFactory;
        return this;
    }

    public SimpleDirContextFactoryBuilder setConnectTimeout(int connectTimeout) {
        this.assertNotBuilt();
        this.connectTimeout = connectTimeout;
        return this;
    }

    public SimpleDirContextFactoryBuilder setReadTimeout(int readTimeout) {
        this.assertNotBuilt();
        this.readTimeout = readTimeout;
        return this;
    }

    public SimpleDirContextFactoryBuilder setConnectionProperties(Properties connectionProperties) {
        this.assertNotBuilt();
        this.connectionProperties = connectionProperties;
        return this;
    }

    public DirContextFactory build() {
        this.assertNotBuilt();
        if (this.providerUrl == null) {
            throw ElytronMessages.log.noProviderUrlSet();
        }
        this.built = true;
        return new SimpleDirContextFactory();
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw ElytronMessages.log.builderAlreadyBuilt();
        }
    }

    private class SimpleDirContextFactory
    implements DirContextFactory {
        private SimpleDirContextFactory() {
        }

        @Override
        public DirContext obtainDirContext(DirContextFactory.ReferralMode mode) throws NamingException {
            char[] charPassword = null;
            if (SimpleDirContextFactoryBuilder.this.securityCredential != null) {
                charPassword = SimpleDirContextFactoryBuilder.this.securityCredential.toCharArray();
            } else if (SimpleDirContextFactoryBuilder.this.credentialSource != null) {
                Destroyable password = null;
                try {
                    PasswordCredential credential = SimpleDirContextFactoryBuilder.this.credentialSource.getCredential(PasswordCredential.class);
                    if (credential == null) {
                        throw ElytronMessages.log.couldNotObtainCredential();
                    }
                    password = credential.getPassword(ClearPassword.class);
                    if (password == null) {
                        throw ElytronMessages.log.couldNotObtainCredential();
                    }
                    charPassword = password.getPassword();
                }
                catch (Exception e) {
                    throw ElytronMessages.log.couldNotObtainCredentialWithCause(e);
                }
                finally {
                    try {
                        if (password != null) {
                            password.destroy();
                        }
                    }
                    catch (DestroyFailedException e) {
                        ElytronMessages.log.credentialDestroyingFailed(e);
                    }
                }
            }
            return this.createDirContext(SimpleDirContextFactoryBuilder.this.securityPrincipal, charPassword, mode);
        }

        @Override
        public DirContext obtainDirContext(CallbackHandler handler, DirContextFactory.ReferralMode mode) throws NamingException {
            NameCallback nameCallback = new NameCallback("Principal Name");
            PasswordCallback passwordCallback = new PasswordCallback("Password", false);
            try {
                handler.handle(new Callback[]{nameCallback, passwordCallback});
            }
            catch (Exception e) {
                throw ElytronMessages.log.couldNotObtainCredentialWithCause(e);
            }
            String securityPrincipal = nameCallback.getName();
            if (securityPrincipal == null) {
                throw ElytronMessages.log.couldNotObtainPrincipal();
            }
            char[] securityCredential = passwordCallback.getPassword();
            if (securityCredential == null) {
                throw ElytronMessages.log.couldNotObtainCredential();
            }
            return this.createDirContext(securityPrincipal, securityCredential, mode);
        }

        private DirContext createDirContext(String securityPrincipal, char[] securityCredential, DirContextFactory.ReferralMode mode) throws NamingException {
            InitialLdapContext initialContext;
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", SimpleDirContextFactoryBuilder.this.initialContextFactory);
            env.put("java.naming.provider.url", SimpleDirContextFactoryBuilder.this.providerUrl);
            env.put("java.naming.security.authentication", SimpleDirContextFactoryBuilder.this.securityAuthentication);
            if (securityPrincipal != null) {
                env.put("java.naming.security.principal", securityPrincipal);
            }
            if (securityCredential != null) {
                env.put("java.naming.security.credentials", securityCredential);
            }
            env.put("java.naming.referral", mode == null ? DirContextFactory.ReferralMode.IGNORE.getValue() : mode.getValue());
            if (SimpleDirContextFactoryBuilder.this.socketFactory != null) {
                env.put(SimpleDirContextFactoryBuilder.SOCKET_FACTORY, ThreadLocalSSLSocketFactory.class.getName());
            }
            env.put(SimpleDirContextFactoryBuilder.CONNECT_TIMEOUT, Integer.toString(SimpleDirContextFactoryBuilder.this.connectTimeout));
            env.put(SimpleDirContextFactoryBuilder.READ_TIMEOUT, Integer.toString(SimpleDirContextFactoryBuilder.this.readTimeout));
            if (SimpleDirContextFactoryBuilder.this.connectionProperties != null) {
                for (Object key2 : SimpleDirContextFactoryBuilder.this.connectionProperties.keySet()) {
                    Object value2 = SimpleDirContextFactoryBuilder.this.connectionProperties.get(key2.toString());
                    if (value2 == null) continue;
                    env.put(key2.toString(), value2.toString());
                }
            }
            if (ElytronMessages.log.isDebugEnabled()) {
                ElytronMessages.log.debugf("Creating [" + InitialDirContext.class + "] with environment:", new Object[0]);
                env.forEach((key, value) -> ElytronMessages.log.debugf("    Property [%s] with Value [%s]", key, value));
            }
            try {
                if (SimpleDirContextFactoryBuilder.this.socketFactory != null) {
                    ThreadLocalSSLSocketFactory.set(SimpleDirContextFactoryBuilder.this.socketFactory);
                }
                initialContext = new InitialLdapContext(env, null);
            }
            catch (NamingException ne) {
                ElytronMessages.log.debugf((Throwable)ne, "Could not create [%s]. Failed to connect to LDAP server.", (Object)InitialLdapContext.class);
                throw ne;
            }
            finally {
                if (SimpleDirContextFactoryBuilder.this.socketFactory != null) {
                    ThreadLocalSSLSocketFactory.unset();
                }
            }
            ElytronMessages.log.debugf("[%s] successfully created. Connection established to LDAP server.", (Object)initialContext);
            return new DelegatingLdapContext(initialContext, this::returnContext, SimpleDirContextFactoryBuilder.this.socketFactory);
        }

        @Override
        public void returnContext(DirContext context) {
            if (context == null) {
                return;
            }
            if (context instanceof InitialDirContext) {
                try {
                    context.close();
                    ElytronMessages.log.debugf("Context [%s] was closed. Connection closed or just returned to the pool.", (Object)context);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }
}

