/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph.dmr;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ResourceAddress
extends ModelNode {
    public static ResourceAddress of(String address) {
        if (!Strings.isNullOrEmpty(address) && !"/".equals(address)) {
            ModelNode node = new ModelNode();
            String normalized = address.startsWith("/") ? address.substring(1) : address;
            Splitter.on('/').withKeyValueSeparator('=').split(normalized).forEach((key, value) -> node.add().set((String)key, (String)value));
            return new ResourceAddress(node);
        }
        return new ResourceAddress();
    }

    private ResourceAddress() {
        this.setEmptyList();
    }

    private ResourceAddress(ModelNode address) {
        this.set(address);
    }

    @Override
    public ResourceAddress add(String segment) {
        ResourceAddress address = new ResourceAddress(this);
        if (segment != null) {
            List<String> parts = Splitter.on('=').limit(2).splitToList(segment);
            if (parts.size() == 1) {
                address.add().set(parts.get(0), "*");
            } else if (parts.size() == 2) {
                address.add().set(parts.get(0), parts.get(1));
            }
        }
        return address;
    }

    public String getName() {
        if (this.size() == 0) {
            return "/";
        }
        if (this.lastName() != null && this.lastValue() != null) {
            if ("*".equals(this.lastValue())) {
                return this.lastName();
            }
            return this.lastName() + "=" + this.lastValue();
        }
        return "n/a";
    }

    public int size() {
        return this.isDefined() ? this.asList().size() : 0;
    }

    public boolean isSingleton() {
        return this.size() != 0 && !"*".equals(this.lastValue());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isDefined()) {
            builder.append("/");
            Iterator<Property> iterator = this.asPropertyList().iterator();
            while (iterator.hasNext()) {
                Property segment = iterator.next();
                builder.append(segment.getName()).append("=").append(segment.getValue().asString());
                if (!iterator.hasNext()) continue;
                builder.append("/");
            }
        } else {
            builder.append("n/a");
        }
        return builder.toString();
    }

    private String lastName() {
        List<Property> properties = this.asPropertyList();
        if (!properties.isEmpty()) {
            return properties.get(properties.size() - 1).getName();
        }
        return null;
    }

    private String lastValue() {
        List<Property> properties = this.asPropertyList();
        if (!properties.isEmpty()) {
            return properties.get(properties.size() - 1).getValue().asString();
        }
        return null;
    }
}

