/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.UnaryOperator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.security.sasl.SaslClientFactory;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.ClientConnectionOpenListener;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteConnectionProviderMXBean;
import org.jboss.remoting3.remote.ServerConnectionOpenListener;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Result;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.SslChannel;
import org.xnio.ssl.JsseSslConnection;
import org.xnio.ssl.SslConnection;

class RemoteConnectionProvider
extends AbstractHandleableCloseable<ConnectionProvider>
implements ConnectionProvider {
    static final boolean USE_POOLING;
    static final boolean LEAK_DEBUGGING;
    private final ProviderInterface providerInterface = new ProviderInterface();
    private final XnioWorker xnioWorker;
    private final ConnectionProviderContext connectionProviderContext;
    private final boolean sslRequired;
    private final boolean sslEnabled;
    private final Collection<Cancellable> pendingInboundConnections = Collections.synchronizedSet(new HashSet());
    private final Set<RemoteConnectionHandler> handlers = Collections.synchronizedSet(new HashSet());
    private final MBeanServer server;
    private final ObjectName objectName;

    RemoteConnectionProvider(OptionMap optionMap, ConnectionProviderContext connectionProviderContext) throws IOException {
        super(connectionProviderContext.getExecutor());
        this.sslRequired = optionMap.get(Options.SECURE, false);
        this.sslEnabled = optionMap.get(Options.SSL_ENABLED, true);
        this.xnioWorker = connectionProviderContext.getXnioWorker();
        this.connectionProviderContext = connectionProviderContext;
        MBeanServer server = null;
        ObjectName objectName = null;
        try {
            server = ManagementFactory.getPlatformMBeanServer();
            objectName = new ObjectName("jboss.remoting.handler", "name", connectionProviderContext.getEndpoint().getName() + "-" + this.hashCode());
            server.registerMBean(new RemoteConnectionProviderMXBean(){

                @Override
                public void dumpConnectionState() {
                    RemoteConnectionProvider.this.doDumpConnectionState();
                }

                @Override
                public String dumpConnectionStateToString() {
                    return RemoteConnectionProvider.this.doGetConnectionState();
                }
            }, objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = server;
        this.objectName = objectName;
    }

    private void doDumpConnectionState() {
        StringBuilder b = new StringBuilder();
        this.doGetConnectionState(b);
        Messages.log.info(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetConnectionState(StringBuilder b) {
        b.append("Connection state for ").append(this).append(':').append('\n');
        Set<RemoteConnectionHandler> set = this.handlers;
        synchronized (set) {
            for (RemoteConnectionHandler handler : this.handlers) {
                handler.dumpState(b);
            }
        }
    }

    private String doGetConnectionState() {
        StringBuilder b = new StringBuilder();
        this.doGetConnectionState(b);
        return b.toString();
    }

    @Override
    public Cancellable connect(final URI destination, SocketAddress bindAddress, final OptionMap connectOptions, Result<ConnectionHandlerFactory> result, final AuthenticationConfiguration authenticationConfiguration, SecurityFactory<SSLContext> sslContextFactory, final UnaryOperator<SaslClientFactory> saslClientFactoryOperator, final Collection<String> serverMechs) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Connection provider is closed");
        }
        Assert.checkNotNullParam("destination", destination);
        Assert.checkNotNullParam("connectOptions", connectOptions);
        Assert.checkNotNullParam("result", result);
        Assert.checkNotNullParam("authenticationConfiguration", authenticationConfiguration);
        Assert.checkNotNullParam("saslClientFactoryOperator", saslClientFactoryOperator);
        Messages.log.tracef("Attempting to connect to \"%s\" with options %s", (Object)destination, (Object)connectOptions);
        final FutureResult cancellableResult = new FutureResult();
        cancellableResult.addCancelHandler(new Cancellable(){

            @Override
            public Cancellable cancel() {
                cancellableResult.setCancelled();
                return this;
            }
        });
        IoFuture returnedFuture = cancellableResult.getIoFuture();
        returnedFuture.addNotifier(IoUtils.resultNotifier(), result);
        boolean useSsl = this.sslRequired || this.sslEnabled && connectOptions.get(Options.SSL_ENABLED, true);
        ChannelListener<StreamConnection> openListener = new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                try {
                    connection.setOption(Options.TCP_NODELAY, Boolean.TRUE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                SslChannel sslChannel = connection instanceof SslChannel ? (SslChannel)((Object)connection) : null;
                final RemoteConnection remoteConnection = new RemoteConnection(connection, sslChannel, connectOptions, RemoteConnectionProvider.this);
                cancellableResult.addCancelHandler(new Cancellable(){

                    @Override
                    public Cancellable cancel() {
                        RemoteConnectionHandler.sendCloseRequestBody(remoteConnection);
                        remoteConnection.handlePreAuthCloseRequest();
                        return this;
                    }
                });
                if (connection.isOpen()) {
                    remoteConnection.setResult(cancellableResult);
                    connection.getSinkChannel().setWriteListener(remoteConnection.getWriteListener());
                    ClientConnectionOpenListener openListener = new ClientConnectionOpenListener(destination, remoteConnection, RemoteConnectionProvider.this.connectionProviderContext, authenticationConfiguration, saslClientFactoryOperator, serverMechs, connectOptions);
                    openListener.handleEvent(connection.getSourceChannel());
                }
            }
        };
        AuthenticationContextConfigurationClient configurationClient = ClientConnectionOpenListener.AUTH_CONFIGURATION_CLIENT;
        InetSocketAddress address = configurationClient.getDestinationInetSocketAddress(destination, authenticationConfiguration, 0);
        final IoFuture<StreamConnection> future = useSsl ? this.createSslConnection(destination, (InetSocketAddress)bindAddress, address, connectOptions, authenticationConfiguration, sslContextFactory, openListener) : this.createConnection(destination, (InetSocketAddress)bindAddress, address, connectOptions, openListener);
        this.pendingInboundConnections.add(returnedFuture);
        future.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, FutureResult<ConnectionHandlerFactory>>(){

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectionHandlerFactory> attachment) {
                attachment.setException(exception);
            }

            @Override
            public void handleCancelled(FutureResult<ConnectionHandlerFactory> attachment) {
                attachment.setCancelled();
            }
        }, cancellableResult);
        returnedFuture.addNotifier(new IoFuture.HandlingNotifier<ConnectionHandlerFactory, IoFuture<ConnectionHandlerFactory>>(){

            @Override
            public void handleCancelled(IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
                future.cancel();
            }

            @Override
            public void handleFailed(IOException exception, IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
            }

            @Override
            public void handleDone(ConnectionHandlerFactory data, IoFuture<ConnectionHandlerFactory> attachment) {
                RemoteConnectionProvider.this.pendingInboundConnections.remove(attachment);
            }
        }, returnedFuture);
        return returnedFuture;
    }

    protected IoFuture<StreamConnection> createConnection(URI uri, InetSocketAddress bindAddress, InetSocketAddress destination, OptionMap connectOptions, ChannelListener<StreamConnection> openListener) {
        return bindAddress == null ? this.xnioWorker.openStreamConnection(destination, openListener, connectOptions) : this.xnioWorker.openStreamConnection(bindAddress, destination, openListener, null, connectOptions);
    }

    protected IoFuture<SslConnection> createSslConnection(final URI uri, InetSocketAddress bindAddress, InetSocketAddress destination, final OptionMap connectOptions, final AuthenticationConfiguration configuration, final SecurityFactory<SSLContext> sslContextFactory, final ChannelListener<StreamConnection> openListener) {
        IoFuture<StreamConnection> futureConnection = bindAddress == null ? this.xnioWorker.openStreamConnection(destination, null, connectOptions) : this.xnioWorker.openStreamConnection(bindAddress, destination, null, null, connectOptions);
        FutureResult futureResult = new FutureResult(this.connectionProviderContext.getExecutor());
        futureResult.addCancelHandler(futureConnection);
        futureConnection.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, FutureResult<SslConnection>>(){

            @Override
            public void handleCancelled(FutureResult<SslConnection> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<SslConnection> result) {
                result.setException(exception);
            }

            @Override
            public void handleDone(StreamConnection streamConnection, FutureResult<SslConnection> result) {
                SSLEngine engine;
                AuthenticationContextConfigurationClient configurationClient = ClientConnectionOpenListener.AUTH_CONFIGURATION_CLIENT;
                String realHost = configurationClient.getRealHost(uri, configuration);
                int realPort = configurationClient.getRealPort(uri, configuration);
                try {
                    engine = ((SSLContext)sslContextFactory.create()).createSSLEngine(realHost, realPort);
                    engine.setUseClientMode(true);
                }
                catch (GeneralSecurityException e) {
                    result.setException(new IOException(e));
                    IoUtils.safeClose((Closeable)streamConnection);
                    return;
                }
                JsseSslConnection sslConnection = new JsseSslConnection(streamConnection, engine);
                streamConnection.getCloseSetter().set(channel -> IoUtils.safeClose((Closeable)sslConnection));
                if (RemoteConnectionProvider.this.sslRequired || !connectOptions.get(Options.SSL_STARTTLS, false)) {
                    try {
                        sslConnection.startHandshake();
                    }
                    catch (IOException e) {
                        result.setException(new IOException(e));
                        IoUtils.safeClose((Closeable)streamConnection);
                        return;
                    }
                }
                result.setResult(sslConnection);
                openListener.handleEvent(sslConnection);
            }
        }, futureResult);
        return futureResult.getIoFuture();
    }

    @Override
    public Object getProviderInterface() {
        return this.providerInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() {
        try {
            Cancellable[] cancellableArray = this.pendingInboundConnections;
            synchronized (this.pendingInboundConnections) {
                Cancellable[] cancellables = this.pendingInboundConnections.toArray(new Cancellable[this.pendingInboundConnections.size()]);
                this.pendingInboundConnections.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                for (Cancellable pendingConnection : cancellables) {
                    pendingConnection.cancel();
                }
                this.closeComplete();
            }
        }
        finally {
            if (this.server != null && this.objectName != null) {
                try {
                    this.server.unregisterMBean(this.objectName);
                }
                catch (Throwable throwable) {}
            }
        }
        {
            return;
        }
    }

    void addConnectionHandler(RemoteConnectionHandler connectionHandler) {
        this.handlers.add(connectionHandler);
    }

    void removeConnectionHandler(RemoteConnectionHandler connectionHandler) {
        this.handlers.remove(connectionHandler);
    }

    @Override
    protected Executor getExecutor() {
        return super.getExecutor();
    }

    public String toString() {
        return String.format("Remoting remote connection provider %x for %s", this.hashCode(), this.connectionProviderContext.getEndpoint());
    }

    protected XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    public ConnectionProviderContext getConnectionProviderContext() {
        return this.connectionProviderContext;
    }

    static {
        boolean usePooling = true;
        boolean leakDebugging = false;
        try {
            usePooling = Boolean.parseBoolean(System.getProperty("jboss.remoting.pooled-buffers", "true"));
            leakDebugging = Boolean.parseBoolean(System.getProperty("jboss.remoting.debug-buffer-leaks", "false"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        USE_POOLING = usePooling;
        LEAK_DEBUGGING = leakDebugging;
    }

    final class ProviderInterface
    implements NetworkServerProvider {
        ProviderInterface() {
        }

        @Override
        public AcceptingChannel<StreamConnection> createServer(SocketAddress bindAddress, OptionMap optionMap, SaslAuthenticationFactory saslAuthenticationFactory, SSLContext sslContext) throws IOException {
            Assert.checkNotNullParam("bindAddress", bindAddress);
            Assert.checkNotNullParam("optionMap", optionMap);
            Assert.checkNotNullParam("saslAuthenticationFactory", saslAuthenticationFactory);
            AcceptingChannel<StreamConnection> result = sslContext != null && (RemoteConnectionProvider.this.sslRequired || RemoteConnectionProvider.this.sslEnabled && optionMap.get(Options.SSL_ENABLED, true)) ? RemoteConnectionProvider.this.xnioWorker.createStreamConnectionServer(bindAddress, channel -> {
                int realPort;
                String realHost;
                StreamConnection streamConnection = this.acceptAndConfigure((AcceptingChannel<StreamConnection>)channel);
                if (streamConnection == null) {
                    return;
                }
                InetSocketAddress peerAddress = streamConnection.getPeerAddress(InetSocketAddress.class);
                if (peerAddress != null) {
                    realHost = peerAddress.getHostString();
                    realPort = peerAddress.getPort();
                } else {
                    realHost = null;
                    realPort = 0;
                }
                SSLEngine engine = sslContext.createSSLEngine(realHost, realPort);
                engine.setUseClientMode(false);
                JsseSslConnection sslConnection = new JsseSslConnection(streamConnection, engine);
                if (RemoteConnectionProvider.this.sslRequired || !optionMap.get(Options.SSL_STARTTLS, false)) {
                    try {
                        sslConnection.startHandshake();
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)sslConnection);
                        Messages.log.failedToAccept(e);
                    }
                }
                this.handleAccepted(sslConnection, sslConnection, optionMap, saslAuthenticationFactory);
            }, optionMap) : RemoteConnectionProvider.this.xnioWorker.createStreamConnectionServer(bindAddress, channel -> {
                StreamConnection streamConnection = this.acceptAndConfigure((AcceptingChannel<StreamConnection>)channel);
                if (streamConnection == null) {
                    return;
                }
                this.handleAccepted(streamConnection, null, optionMap, saslAuthenticationFactory);
            }, optionMap);
            RemoteConnectionProvider.this.addCloseHandler((closed, exception) -> IoUtils.safeClose((Closeable)result));
            result.resumeAccepts();
            return result;
        }

        private StreamConnection acceptAndConfigure(AcceptingChannel<StreamConnection> channel) {
            StreamConnection streamConnection;
            try {
                streamConnection = (StreamConnection)channel.accept();
            }
            catch (IOException e) {
                Messages.log.failedToAccept(e);
                return null;
            }
            if (streamConnection == null) {
                return null;
            }
            try {
                streamConnection.setOption(Options.TCP_NODELAY, Boolean.TRUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return streamConnection;
        }

        private void handleAccepted(StreamConnection accepted, SslChannel sslChannel, OptionMap serverOptionMap, SaslAuthenticationFactory saslAuthenticationFactory) {
            RemoteConnection connection = new RemoteConnection(accepted, sslChannel, serverOptionMap, RemoteConnectionProvider.this);
            ServerConnectionOpenListener openListener = new ServerConnectionOpenListener(connection, RemoteConnectionProvider.this.connectionProviderContext, saslAuthenticationFactory, serverOptionMap);
            accepted.getSinkChannel().setWriteListener(connection.getWriteListener());
            Messages.log.tracef("Accepted connection from %s to %s", (Object)connection.getPeerAddress(), (Object)connection.getLocalAddress());
            openListener.handleEvent(accepted.getSourceChannel());
        }
    }
}

