/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hawt.app.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.filters.ResolveFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.MarkerHandler;
import org.apache.maven.plugin.dependency.utils.markers.SourcesFileMarkerHandler;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class BuildMojo
extends AbstractDependencyFilterMojo {
    @Parameter(property="hawt-app.source", defaultValue="${basedir}/src/main/hawt-app")
    protected File source;
    @Parameter(property="hawt-app.assembly", defaultValue="${project.build.directory}/hawt-app")
    protected File assembly;
    @Parameter(property="hawt-app.archive", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-app.tar.gz")
    protected File archive;
    @Parameter(property="hawt-app.archiveClassifier", defaultValue="app")
    protected String archiveClassifier;
    @Parameter(property="hawt-app.archivePrefix", defaultValue="${project.artifactId}-${project.version}-app/")
    protected String archivePrefix;
    @Parameter(property="hawt-app.main")
    protected String main;
    @Component(role=Archiver.class, hint="tar")
    protected Archiver archiver;
    @Component
    private MavenProjectHelper projectHelper;

    protected void doExecute() throws MojoExecutionException {
        DependencyStatusSets results = this.getDependencySets(false, false);
        File libDir = new File(this.assembly, "lib");
        libDir.mkdirs();
        File binDir = new File(this.assembly, "bin");
        binDir.mkdirs();
        ArrayList<String> classpath = new ArrayList<String>();
        if (this.project.getArtifact().getFile() != null) {
            File target = new File(libDir, this.project.getArtifact().getFile().getName());
            classpath.add(target.getName());
            try {
                FileUtils.copyFile((File)this.project.getArtifact().getFile(), (File)target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy artifact to lib dir", (Exception)e);
            }
        }
        for (Artifact artifact : results.getResolvedDependencies()) {
            File file = artifact.getFile().getAbsoluteFile();
            try {
                File target = new File(libDir, file.getName());
                int dupCounter = 1;
                while (classpath.contains(target.getName())) {
                    target = new File(libDir, "dup" + dupCounter + "-" + file.getName());
                    ++dupCounter;
                }
                classpath.add(target.getName());
                FileUtils.copyFile((File)artifact.getFile(), (File)target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy artifact to lib dir", (Exception)e);
            }
        }
        String classpathTxt = StringUtils.join(classpath.iterator(), (String)"\r\n") + "\r\n";
        try {
            FileUtils.fileWrite((File)new File(libDir, ".classpath"), (String)classpathTxt);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could create the .classpath file", (Exception)e);
        }
        HashMap<String, String> interpolations = new HashMap<String, String>();
        interpolations.put("mvn.artifactId", this.project.getArtifactId());
        if (this.main != null) {
            interpolations.put("mvn.main", this.main);
        }
        this.copyResource("bin/run", new File(binDir, "run"), "\n", interpolations);
        this.chmodExecutable(new File(binDir, "run"));
        if (this.source != null && this.source.exists()) {
            try {
                FileUtils.copyDirectoryStructure((File)this.source, (File)this.assembly);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could copy the hawt-app resources", (Exception)e);
            }
        }
        this.archiver.setDestFile(this.archive);
        this.archiver.addFileSet((FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)this.assembly).prefixed(this.archivePrefix)).includeExclude(null, new String[]{"bin/*"})).includeEmptyDirs(true));
        this.archiver.setFileMode(493);
        this.archiver.addFileSet((FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)this.assembly).prefixed(this.archivePrefix)).includeExclude(new String[]{"bin/*"}, null)).includeEmptyDirs(true));
        try {
            this.archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create the " + this.archive + " file", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "tar.gz", this.archiveClassifier, this.archive);
    }

    private void chmodExecutable(File file) {
        try {
            Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void copyResource(String source, File target, String separator, HashMap<String, String> interpolations) throws MojoExecutionException {
        try {
            String content = this.loadTextResource(((Object)((Object)this)).getClass().getResource(source));
            if (interpolations != null) {
                content = StringUtils.interpolate((String)content, interpolations);
            }
            content = content.replaceAll("\\r?\\n", Matcher.quoteReplacement(separator));
            FileUtils.fileWrite((File)target, (String)content);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could create the " + target + " file", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTextResource(URL resource) throws IOException {
        InputStream is = resource.openStream();
        try {
            String string = IOUtil.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new ResolveFileFilter((MarkerHandler)new SourcesFileMarkerHandler(this.markersDirectory));
    }
}

