/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.api.query;

import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.SortOrder;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface GroupQuery extends Query
{

   Collection<Group> execute() throws QueryException;

   Group uniqueResult() throws QueryException;

   List<Group> list() throws QueryException;

   GroupQuery setId(String id);

   GroupQuery setNameAndType(String name, String type);
                                                                      
   GroupQuery setName(String name);

   GroupQuery setType(String type);

   GroupQuery addAssociatedGroup(Group group, boolean parent);

   GroupQuery addAssociatedGroup(String id, boolean parent);

   GroupQuery addAssociatedGroups(Collection<Group> groups, boolean parent);

   GroupQuery addAssociatedGroupsIds(Collection<String> ids, boolean parent);

   GroupQuery addAssociatedUser(User user);

   GroupQuery addAssociatedUser(String id);

   GroupQuery addAssociatedUsers(Collection<User> users);

   GroupQuery addAssociatedUsersIds(Collection<String> ids);

   GroupQuery addUserConnectedByRole(User user);

   GroupQuery addUserConnectedByRole(String id);

   GroupQuery addUsersConnectedByRole(Collection<User> users);

   GroupQuery addUsersIdsConnectedByRole(Collection<String> ids);

   GroupQuery addRelatedUser(User user);

   GroupQuery addRelatedUser(String id);

   GroupQuery sort(SortOrder order) throws UnsupportedQueryCriterium;

   GroupQuery sortAttributeName(String name) throws UnsupportedQueryCriterium;

   GroupQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium;

   GroupQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium;



}
