/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.api.query;

import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.Role;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface RoleQuery extends Query
{

   Collection<Role> execute() throws QueryException;

   Role uniqueResult() throws QueryException;

   List<Role> list() throws QueryException;

   RoleQuery setUser(User user);

   RoleQuery setUser(String id);

   RoleQuery setGroup(Group group);

   RoleQuery setGroup(String id);

   RoleQuery setRoleType(RoleType roleType);

   RoleQuery setRoleType(String string);

   RoleQuery setIdentityType(IdentityType identityType);

   RoleQuery setIdentityTypeId(String id);

}
