/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.api.query;

import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.SortOrder;

import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface UserQuery extends Query
{
   Collection<User> execute() throws QueryException;

   User uniqueResult() throws QueryException;

   List<User> list() throws QueryException;

   UserQuery withUserId(String id);

   UserQuery addAssociatedGroup(Group group);

   UserQuery addAssociatedGroup(String id);

   UserQuery addAssociatedGroups(Collection<Group> groups);

   UserQuery addAssociatedGroupsIds(Collection<String> groups);

   UserQuery addGroupConnectedWithRole(Group group);

   UserQuery addGroupConnectedWithRole(String id);

   UserQuery addGroupsConnectedWithRole(Collection<Group> groups);

   UserQuery addGroupsIdsConnectedWithRole(Collection<String> groups);

   UserQuery addRelatedGroup(Group group);

   UserQuery addRelatedGroup(String id);

   UserQuery addRelatedGroups(Collection<Group> group);

   UserQuery addRelatedGroupsIds(Collection<String> ids);

   UserQuery sort(SortOrder order) throws UnsupportedQueryCriterium;

   UserQuery sortAttributeName(String name) throws UnsupportedQueryCriterium;

   UserQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium;

   UserQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium;

}
