/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.api;

import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.UnsupportedCriterium;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class IdentitySearchCriteriaImpl implements IdentitySearchCriteria, IdentityObjectSearchCriteria
{

   private boolean sorted = false;

   private String sortByName;

   private boolean ascending = true;

   private boolean paged = false;

   private int firstResult;

   private int maxResults;

   private boolean filtered = false;

   private final Map<String, String[]> attributes = new HashMap<String, String[]>();

   private String filter;

   public IdentitySearchCriteriaImpl()
   {

   }

   public IdentitySearchCriteria sort(SortOrder order) throws UnsupportedCriterium
   {
      sorted = true;
      if (order.equals(SortOrder.ASCENDING))
      {
         ascending = true;
      }
      else
      {
         ascending = false;
      }

      return this;
   }

   public IdentitySearchCriteria sortAttributeName(String name) throws UnsupportedCriterium
   {
      sorted = true;
      sortByName = name;

      return this;
   }

   public IdentitySearchCriteria page(int firstResult, int maxResults) throws UnsupportedCriterium
   {
      paged = true;

      this.firstResult = firstResult;
      this.maxResults = maxResults;


      return this;
   }

   public IdentitySearchCriteria attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedCriterium
   {
      if (attributeName == null)
      {
         throw new IllegalArgumentException("Attribute name is null");
      }

      if (attributeValue == null)
      {
         throw new IllegalArgumentException("Attribute values are null");
         
      }

      filtered = true;

      attributes.put(attributeName, attributeValue);

      return this;
   }

   public IdentitySearchCriteria idFilter(String filter) throws UnsupportedCriterium
   {
      if (filter == null)
      {
         throw new IllegalArgumentException("ID filter is null");
      }

      this.filter = filter;

      return this;
   }

   public String getFilter()
   {
      return filter;
   }

   public boolean isSorted()
   {
      return sorted;
   }

   public boolean isAscending()
   {
      return ascending;
   }

   public String getSortAttributeName()
   {
      return sortByName;
   }

   public boolean isPaged()
   {
      return paged;
   }

   public int getFirstResult()
   {
      return firstResult;
   }

   public int getMaxResults()
   {
      return maxResults;
   }

   public boolean isFiltered()
   {
      return filtered;
   }

   public Map<String, String[]> getValues()
   {
      return attributes;
   }

   @Override
   public boolean equals(Object o)
   {
      if (this == o)
      {
         return true;
      }
      if (o == null || getClass() != o.getClass())
      {
         return false;
      }

      IdentitySearchCriteriaImpl that = (IdentitySearchCriteriaImpl)o;

      if (ascending != that.ascending)
      {
         return false;
      }
      if (filtered != that.filtered)
      {
         return false;
      }
      if (firstResult != that.firstResult)
      {
         return false;
      }
      if (maxResults != that.maxResults)
      {
         return false;
      }
      if (paged != that.paged)
      {
         return false;
      }
      if (sorted != that.sorted)
      {
         return false;
      }
      if (!attributes.equals(that.attributes))
      {
         return false;
      }
      if (filter != null ? !filter.equals(that.filter) : that.filter != null)
      {
         return false;
      }
      if (sortByName != null ? !sortByName.equals(that.sortByName) : that.sortByName != null)
      {
         return false;
      }

      return true;
   }

   @Override
   public int hashCode()
   {
      int result = (sorted ? 1 : 0);
      result = 31 * result + (sortByName != null ? sortByName.hashCode() : 0);
      result = 31 * result + (ascending ? 1 : 0);
      result = 31 * result + (paged ? 1 : 0);
      result = 31 * result + firstResult;
      result = 31 * result + maxResults;
      result = 31 * result + (filtered ? 1 : 0);
      result = 31 * result + attributes.hashCode();
      result = 31 * result + (filter != null ? filter.hashCode() : 0);
      return result;
   }
}
