/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.store.ldap;

import org.jboss.identity.idm.spi.store.IdentityStoreSession;
import org.jboss.identity.idm.exception.IdentityException;

import javax.naming.ldap.LdapContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.Context;
import java.util.Hashtable;

/**
 * Session around LDAP store. Exposes LDAP connection (LdapContext) and does nothing for transaction related methods
 *
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class LDAPIdentityStoreSessionImpl implements IdentityStoreSession
{

   private final String INITIAL_CONTEXT_FACTORY;

   private final String PROVIDER_URL;

   private final String SECURITY_AUTHENTICATION;

   private final String SECURITY_PRINCIPAL;

   private final String SECURITY_CREDENTIALS;


   public LDAPIdentityStoreSessionImpl(String INITIAL_CONTEXT_FACTORY,
                                       String PROVIDER_URL,
                                       String SECURITY_AUTHENTICATION,
                                       String SECURITY_PRINCIPAL,
                                       String SECURITY_CREDENTIALS)
   {
      this.INITIAL_CONTEXT_FACTORY = INITIAL_CONTEXT_FACTORY;
      this.PROVIDER_URL = PROVIDER_URL;
      this.SECURITY_AUTHENTICATION = SECURITY_AUTHENTICATION;
      this.SECURITY_PRINCIPAL = SECURITY_PRINCIPAL;
      this.SECURITY_CREDENTIALS = SECURITY_CREDENTIALS;
   }

   public LdapContext getLdapContext() throws Exception
   {
      Hashtable<String,String> env = new Hashtable<String,String>();
      env.put(Context.INITIAL_CONTEXT_FACTORY, INITIAL_CONTEXT_FACTORY);
      env.put(Context.PROVIDER_URL, PROVIDER_URL);
      env.put(Context.SECURITY_AUTHENTICATION, SECURITY_AUTHENTICATION);
      env.put(Context.SECURITY_PRINCIPAL, SECURITY_PRINCIPAL);
      env.put(Context.SECURITY_CREDENTIALS, SECURITY_CREDENTIALS);

      return new InitialLdapContext(env, null);
   }

   public Object getSessionContext() throws IdentityException
   {
      try
      {
         return getLdapContext();
      }
      catch (Exception e)
      {
         throw new IdentityException("Could not create LdapContext", e);
      }
   }

   public void close() throws IdentityException
   {

   }

   public void save() throws IdentityException
   {

   }

   public void clear() throws IdentityException
   {

   }

   public boolean isOpen()
   {
      return false;
   }

   public boolean isTransactionSupported()
   {
      return false;
   }

   public void startTransaction()
   {

   }

   public void commitTransaction()
   {

   }

   public void rollbackTransaction()
   {

   }

   public boolean isTransactionActive()
   {
      return false;
   }
}
