/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;
import org.jboss.identity.idm.impl.api.session.mapper.DirectIdentityObjectTypeMapperImpl;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapperImpl;
import org.jboss.identity.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.store.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySessionFactoryImpl
implements IdentitySessionFactory {
    private final Map<String, IdentitySession> realmMap;

    public IdentitySessionFactoryImpl(Map<String, IdentitySession> realmMap) {
        this.realmMap = realmMap;
    }

    public IdentitySessionFactoryImpl(IdentityConfigurationMetaData configMD) throws Exception {
        this.realmMap = this.createSessionMap(configMD);
    }

    public IdentitySessionFactoryImpl(File configFile) throws Exception {
        IdentityConfigurationMetaData configMD = JAXB2IdentityConfiguration.createConfigurationMetaData(configFile);
        this.realmMap = this.createSessionMap(configMD);
    }

    private Map<String, IdentitySession> createSessionMap(IdentityConfigurationMetaData configMD) throws Exception {
        HashMap<String, IdentityStore> bootstrappedIdentityStores = new HashMap<String, IdentityStore>();
        HashMap<String, IdentityStore> bootstrappedAttributeStores = new HashMap<String, IdentityStore>();
        for (IdentityStoreConfigurationMetaData metaData : configMD.getIdentityStores()) {
            Class<?> storeClass = null;
            try {
                storeClass = Class.forName(metaData.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate identity store:" + metaData.getClassName(), (Throwable)e);
            }
            Class[] partypes = new Class[]{String.class};
            Constructor<?> ct = storeClass.getConstructor(partypes);
            Object[] argList = new Object[]{metaData.getId()};
            IdentityStore store = (IdentityStore)ct.newInstance(argList);
            store.bootstrap(metaData);
            bootstrappedIdentityStores.put(store.getId(), store);
            bootstrappedAttributeStores.put(store.getId(), store);
        }
        HashMap<String, IdentityStoreRepository> bootstrappedRepositories = new HashMap<String, IdentityStoreRepository>();
        for (IdentityRepositoryConfigurationMetaData metaData : configMD.getRepositories()) {
            Class<?> repoClass = null;
            try {
                repoClass = Class.forName(metaData.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate identity store:" + metaData.getClassName(), (Throwable)e);
            }
            Class[] partypes = new Class[]{String.class};
            Constructor<?> ct = repoClass.getConstructor(partypes);
            Object[] argList = new Object[]{metaData.getId()};
            IdentityStoreRepository repo = (IdentityStoreRepository)ct.newInstance(argList);
            repo.bootstrap(metaData, bootstrappedIdentityStores, bootstrappedAttributeStores);
            bootstrappedRepositories.put(repo.getId(), repo);
        }
        HashMap<String, IdentitySession> sessionMap = new HashMap<String, IdentitySession>();
        for (RealmConfigurationMetaData metaData : configMD.getRealms()) {
            String realmName = metaData.getId();
            IdentityStoreRepository repo = (IdentityStoreRepository)bootstrappedRepositories.get(metaData.getIdentityRepositoryIdRef());
            IdentityObjectTypeMapper mapper = null;
            mapper = metaData.getGroupTypeMappings() == null || metaData.getGroupTypeMappings().isEmpty() ? new DirectIdentityObjectTypeMapperImpl(metaData.getIdentityMapping()) : new IdentityObjectTypeMapperImpl(metaData.getGroupTypeMappings(), metaData.getIdentityMapping());
            IdentitySessionImpl session = new IdentitySessionImpl(realmName, repo, mapper);
            sessionMap.put(realmName, session);
        }
        return sessionMap;
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public IdentitySession createIdentitySession(String realmName) {
        return this.realmMap.get(realmName);
    }

    public IdentitySession getCurrentIdentitySession(String realmName) {
        return this.realmMap.get(realmName);
    }
}

