/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.Collection;
import java.util.LinkedList;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.GroupType;
import org.jboss.identity.idm.api.Identity;
import org.jboss.identity.idm.api.IdentitySearchControl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.PersistenceManager;
import org.jboss.identity.idm.api.PersistenceManagerFeaturesDescription;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.searchcontrol.IdentityObjectSearchControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerImpl
extends AbstractManager
implements PersistenceManager {
    private final PersistenceManagerFeaturesDescription featuresDescription = new PersistenceManagerFeaturesDescription(){

        public boolean isIdentitiesAddRemoveSupported() {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isGroupsAddRemoveSupported(GroupType groupType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isIdentitiesSearchControlSupported(IdentitySearchControl control) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            if (control instanceof IdentityObjectSearchControl) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, (IdentityObjectSearchControl)control);
            }
            return false;
        }

        public boolean isIdentitiesSearchControlSupported(Class controlClazz) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, controlClazz);
        }

        public boolean isGroupsSearchControlSupported(GroupType groupType, IdentitySearchControl control) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            if (control instanceof IdentityObjectSearchControl) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, (IdentityObjectSearchControl)control);
            }
            return false;
        }

        public boolean isGroupsSearchControlSupported(GroupType groupType, Class controlClazz) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, controlClazz);
        }
    };

    public PersistenceManagerImpl(IdentitySession session) {
        super(session);
    }

    public PersistenceManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    public Identity createIdentity(String identityName) throws IdentityException {
        IdentityObjectType iot = this.getIdentityObjectType();
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), identityName, iot);
        return this.createIdentity(identityObject);
    }

    public Group createGroup(String groupName, GroupType groupType) throws IdentityException {
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), groupName, iot);
        return this.createGroup(identityObject);
    }

    public void removeIdentity(Identity identity, boolean force) throws IdentityException {
        IdentityObjectType iot = this.getIdentityObjectType();
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity));
    }

    public void removeGroup(Group group, boolean force) throws IdentityException {
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(group));
    }

    public int getIdentityCount() throws IdentityException {
        IdentityObjectType iot = this.getIdentityObjectType();
        return this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
    }

    public int getGroupTypeCount(GroupType groupType) throws IdentityException {
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        return this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
    }

    public Identity findIdentity(String name) throws IdentityException {
        return this.createIdentity(this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getIdentityObjectType()));
    }

    public Identity findIdentityById(String id) throws IdentityException {
        return this.createIdentity(this.getRepository().findIdentityObject(this.getInvocationContext(), id));
    }

    public Collection<Identity> findIdentity(IdentitySearchControl[] controls) throws IdentityException {
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getIdentityObjectType(), this.convertSearchControls(controls));
        LinkedList<Identity> identities = new LinkedList<Identity>();
        for (IdentityObject identityObject : ios) {
            identities.add(this.createIdentity(identityObject));
        }
        return identities;
    }

    public Group findGroup(String name, GroupType groupType) throws IdentityException {
        return this.createGroup(this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getIdentityObjectType(groupType)));
    }

    public Group findGroupById(String id) throws IdentityException {
        return this.createGroup(this.getRepository().findIdentityObject(this.getInvocationContext(), id));
    }

    public Collection<Group> findGroup(GroupType groupType, IdentitySearchControl[] controls) throws IdentityException {
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getIdentityObjectType(groupType), this.convertSearchControls(controls));
        LinkedList<Group> groups = new LinkedList<Group>();
        for (IdentityObject identityObject : ios) {
            groups.add(this.createGroup(identityObject));
        }
        return groups;
    }

    public Collection<Group> findGroup(GroupType groupType) throws IdentityException {
        return this.findGroup(groupType, null);
    }

    public boolean isVirtual(Identity identity) {
        throw new NotYetImplementedException("Postponed");
    }
}

