/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.Identity;
import org.jboss.identity.idm.api.IdentitySearchControl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.RoleManager;
import org.jboss.identity.idm.api.RoleManagerFeaturesDescription;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.model.SimpleRole;
import org.jboss.identity.idm.impl.api.model.SimpleRoleType;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.searchcontrol.IdentityObjectSearchControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleManagerImpl
extends AbstractManager
implements RoleManager {
    public static final IdentityObjectRelationshipType ROLE = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_ROLE";
        }
    };
    private final RoleManagerFeaturesDescription featuresDescription = new RoleManagerFeaturesDescription(){

        public boolean isRoleTypeAddRemoveSupported() {
            return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipNameAddRemoveSupported();
        }

        public boolean isRoleTypeSearchControlSupported(Class controlClazz) {
            return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRoleNameControlSupported(controlClazz);
        }

        public boolean isRoleTypeSearchControlSupported(IdentitySearchControl control) {
            if (control instanceof IdentityObjectSearchControl) {
                return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRoleNameControlSupported((IdentityObjectSearchControl)control);
            }
            return false;
        }
    };

    public RoleManagerImpl(IdentitySession session) {
        super(session);
    }

    public RoleManagerFeaturesDescription getSupportedFeatures() {
        return this.featuresDescription;
    }

    public RoleType createRoleType(String name) throws IdentityException {
        String roleType = null;
        try {
            roleType = this.getRepository().createRelationshipName(this.getInvocationContext(), name);
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return new SimpleRoleType(roleType);
    }

    public void removeRoleType(String name) throws IdentityException {
        try {
            this.getRepository().removeRelationshipName(this.getInvocationContext(), name);
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public void removeRoleType(RoleType roleType) throws IdentityException {
        this.removeRoleType(roleType.getName());
    }

    public RoleType getRoleType(String name) throws IdentityException {
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), null);
            if (names.contains(name)) {
                return new SimpleRoleType(name);
            }
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return null;
    }

    public Collection<RoleType> findRoleTypes(IdentitySearchControl[] controls) throws IdentityException {
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.convertSearchControls(controls));
            HashSet<RoleType> types = new HashSet<RoleType>();
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public Role createRole(RoleType roleType, Identity identity, Group group) throws IdentityException {
        IdentityObjectRelationship rel = this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(identity), this.createIdentityObject(group), ROLE, roleType.getName(), false);
        return new SimpleRole(new SimpleRoleType(rel.getName()), this.createIdentity(rel.getFromIdentityObject()), this.createGroup(rel.getToIdentityObject()));
    }

    public void removeRole(RoleType roleType, Identity identity, Group group) throws IdentityException {
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(identity), this.createIdentityObject(group), ROLE, roleType.getName());
    }

    public void removeRole(Role role) throws IdentityException {
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(role.getIdentity()), this.createIdentityObject(role.getGroup()), ROLE, role.getRoleType().getName());
    }

    public boolean hasRole(Identity identity, Group group, RoleType roleType) throws IdentityException {
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identity), this.createIdentityObject(group), ROLE);
        for (IdentityObjectRelationship rel : rels) {
            if (!rel.getType().getName().equals(ROLE.getName()) || rel.getName() == null || !rel.getName().equals(roleType.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection<RoleType> findRoleTypes(Identity identity, Group group) throws IdentityException {
        return this.findRoleTypes(identity, group, null);
    }

    public Collection<RoleType> findRoleTypes(Identity identity, Group group, IdentitySearchControl[] controls) throws IdentityException {
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identity), this.createIdentityObject(group), ROLE);
        HashSet<RoleType> types = new HashSet<RoleType>();
        for (IdentityObjectRelationship rel : rels) {
            types.add(new SimpleRoleType(rel.getName()));
        }
        return types;
    }

    public Collection<RoleType> findIdentityRoleTypes(Identity identity) throws IdentityException {
        return this.findIdentityRoleTypes(identity, null);
    }

    public Collection<RoleType> findIdentityRoleTypes(Identity identity, IdentitySearchControl[] controls) throws IdentityException {
        HashSet<RoleType> types = new HashSet<RoleType>();
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(identity), this.convertSearchControls(controls));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported", (Throwable)e);
        }
    }

    public Collection<RoleType> findGroupRoleTypes(Group group) throws IdentityException {
        return this.findGroupRoleTypes(group, null);
    }

    public Collection<RoleType> findGroupRoleTypes(Group group, IdentitySearchControl[] controls) throws IdentityException {
        HashSet<RoleType> types = new HashSet<RoleType>();
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(group), this.convertSearchControls(controls));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public Collection<Role> findRoles(IdentityType identityType, RoleType roleType) throws IdentityException {
        HashSet<Role> roles = new HashSet<Role>();
        Set relationships = null;
        relationships = identityType instanceof Identity ? this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, true, true, null) : this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, false, true, null);
        for (IdentityObjectRelationship relationship : relationships) {
            if (!roleType.getName().equals(relationship.getName())) continue;
            roles.add(new SimpleRole(new SimpleRoleType(relationship.getName()), this.createIdentity(relationship.getFromIdentityObject()), this.createGroup(relationship.getToIdentityObject())));
        }
        return roles;
    }
}

