/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.mapper;

import org.jboss.identity.idm.api.GroupType;
import org.jboss.identity.idm.impl.api.model.SimpleGroupType;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.jboss.identity.idm.impl.types.SimpleIdentityObjectType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;

public class DirectIdentityObjectTypeMapperImpl
implements IdentityObjectTypeMapper {
    private final String identityTypeName;

    public DirectIdentityObjectTypeMapperImpl(String identityTypeName) {
        this.identityTypeName = identityTypeName;
    }

    public IdentityObjectType getIdentityObjectType() {
        return new SimpleIdentityObjectType(this.identityTypeName);
    }

    public IdentityObjectType getIdentityObjectType(GroupType groupType) {
        if (groupType == null) {
            throw new IllegalArgumentException("groupType is null");
        }
        return new SimpleIdentityObjectType(groupType.getName());
    }

    public GroupType getGroupType(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        return new SimpleGroupType(identityObjectType.getName());
    }

    public boolean isGroupType(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        return !this.isIdentity(identityObjectType);
    }

    public boolean isIdentity(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        return identityObjectType.getName().equals(this.identityTypeName);
    }
}

