/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.model.hibernate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.jboss.identity.idm.exception.PolicyValidationException;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectTextAttribute;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.jboss.identity.idm.impl.model.hibernate.HibernateRealm;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectCredentialType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamedQueries(value={@NamedQuery(name="findIdentityObjectByNameAndType", query="select o from HibernateIdentityObject o where o.realm like :realm and o.name like :name and o.identityType.name like :typeName"), @NamedQuery(name="findIdentityObjectsByType", query="select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm like :realm and o.identityType.name like :typeName"), @NamedQuery(name="findIdentityObjectsByTypeOrderedByNameAsc", query="select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm like :realm and o.identityType.name like :typeName order by o.name asc"), @NamedQuery(name="findIdentityObjectsByTypeOrderedByNameDesc", query="select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm like :realm and o.identityType.name like :typeName order by o.name desc"), @NamedQuery(name="countIdentityObjectsByType", query="select count(o.id) from HibernateIdentityObject o where o.realm like :realm and o.identityType.name like :typeName")})
@Entity
@Table(name="identity_obj", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "IDENTITY_TYPE", "REALM"})})
public class HibernateIdentityObject
implements IdentityObject {
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="NAME", nullable=false)
    private String name;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="IDENTITY_TYPE", nullable=false)
    private HibernateIdentityObjectType identityType;
    @OneToMany(mappedBy="fromIdentityObject")
    private Set<HibernateIdentityObjectRelationship> fromRelationships = new HashSet<HibernateIdentityObjectRelationship>();
    @OneToMany(mappedBy="toIdentityObject")
    private Set<HibernateIdentityObjectRelationship> toRelationships = new HashSet<HibernateIdentityObjectRelationship>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, mappedBy="identityObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<HibernateIdentityObjectAttribute> attributes = new HashSet<HibernateIdentityObjectAttribute>();
    @CollectionOfElements
    @JoinTable(name="identity_obj_properties", joinColumns={@JoinColumn(name="IDENTITY_OBJ_ID")})
    @Column(name="PROPERTY")
    private Map<String, String> properties = new HashMap<String, String>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Map<String, HibernateIdentityObjectCredential> credentials = new HashMap<String, HibernateIdentityObjectCredential>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, unique=false, name="REALM")
    private HibernateRealm realm;

    public HibernateIdentityObject() {
    }

    public HibernateIdentityObject(String name, HibernateIdentityObjectType identityType, HibernateRealm realm) {
        this.name = name;
        this.identityType = identityType;
        this.realm = realm;
    }

    public String getId() {
        return this.id.toString();
    }

    public void setId(String id) {
        this.id = Long.valueOf(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HibernateIdentityObjectType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(HibernateIdentityObjectType identityType) {
        this.identityType = identityType;
    }

    public String getFQDN() {
        return null;
    }

    public Set<HibernateIdentityObjectAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<HibernateIdentityObjectAttribute> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Collection> getAttributesAsMap() {
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (HibernateIdentityObjectAttribute attribute : this.attributes) {
            Collection values = attribute.getValues();
            map.put(attribute.getName(), values);
        }
        return Collections.unmodifiableMap(map);
    }

    public void addTextAttribute(String name, String[] values) {
        this.attributes.add(new HibernateIdentityObjectTextAttribute(this, name, values));
    }

    public void removeAttribute(String name) {
        HibernateIdentityObjectAttribute attributeToRemove = null;
        for (HibernateIdentityObjectAttribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            attributeToRemove = attribute;
            break;
        }
        if (attributeToRemove != null) {
            this.attributes.remove(attributeToRemove);
        }
    }

    public Set<HibernateIdentityObjectRelationship> getFromRelationships() {
        return this.fromRelationships;
    }

    public void setFromRelationships(Set<HibernateIdentityObjectRelationship> fromRelationships) {
        this.fromRelationships = fromRelationships;
    }

    public void addFromRelationship(HibernateIdentityObjectRelationship fromRelationship) {
        fromRelationship.setFromIdentityObject(this);
        this.fromRelationships.add(fromRelationship);
    }

    public Set<HibernateIdentityObjectRelationship> getToRelationships() {
        return this.toRelationships;
    }

    public void setToRelationships(Set<HibernateIdentityObjectRelationship> toRelationships) {
        this.toRelationships = toRelationships;
    }

    public void addToRelationship(HibernateIdentityObjectRelationship toRelationship) {
        toRelationship.setToIdentityObject(this);
        this.fromRelationships.add(toRelationship);
    }

    public HibernateRealm getRealm() {
        return this.realm;
    }

    public void setRealm(HibernateRealm realm) {
        this.realm = realm;
    }

    public Map<String, HibernateIdentityObjectCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, HibernateIdentityObjectCredential> credentials) {
        this.credentials = credentials;
    }

    public void addCredential(HibernateIdentityObjectCredential credential) {
        credential.setIdentityObject(this);
        this.credentials.put(credential.getType().getName(), credential);
    }

    public boolean hasCredentials() {
        return this.credentials != null && this.credentials.size() > 0;
    }

    public boolean hasCredential(IdentityObjectCredentialType type) {
        return this.credentials != null && this.credentials.keySet().contains(type.getName());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void validatePolicy() throws PolicyValidationException {
    }
}

