/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.hibernate;

import javax.persistence.Persistence;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

public class HibernateIdentityStoreSessionImpl
implements IdentityStoreSession {
    private final HibernateEntityManager hem;

    public HibernateIdentityStoreSessionImpl(HibernateEntityManager hem) {
        this.hem = hem;
    }

    public HibernateIdentityStoreSessionImpl(String persistenceUnit) {
        HibernateEntityManagerFactory emFactory = (HibernateEntityManagerFactory)Persistence.createEntityManagerFactory((String)persistenceUnit);
        this.hem = (HibernateEntityManager)emFactory.createEntityManager();
    }

    public Object getSessionContext() {
        return this.hem;
    }

    public void close() throws IdentityException {
        this.hem.close();
    }

    public void save() throws IdentityException {
        this.hem.flush();
    }

    public void clear() throws IdentityException {
        this.hem.clear();
    }

    public boolean isOpen() {
        return this.hem.isOpen();
    }

    public boolean isTransactionSupported() {
        return true;
    }

    public void startTransaction() {
        this.hem.getTransaction().begin();
    }

    public void commitTransaction() {
        this.hem.getTransaction().commit();
    }

    public void rollbackTransaction() {
        this.hem.getTransaction().rollback();
    }

    public boolean isTransactionActive() {
        return this.hem.getTransaction().isActive();
    }
}

