/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.RelationshipMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLDAPIdentityObjectTypeConfiguration
implements LDAPIdentityObjectTypeConfiguration {
    private final String idAttributeName;
    private final String passwordAttributeName;
    private final String[] ctxDNs;
    private final String entrySearchFilter;
    private final boolean allowCreateEntry;
    private final Map<String, String[]> createEntryAttributeValues;
    private final String[] allowedMembershipTypes;
    private final String membershipAttributeName;
    private final boolean isMembershipAttributeDN;
    private final boolean allowEmptyMemberships;
    private final Map<String, String> attributeNames;
    public static final String ID_ATTRIBUTE_NAME = "idAttributeName";
    public static final String PASSWORD_ATTRIBUTE_NAME = "passwordAttributeName";
    public static final String CTX_DNS = "ctxDNs";
    public static final String ENTRY_SEARCH_FILTER = "entrySearchFilter";
    public static final String ALLOW_CREATE_ENTRY = "allowCreateEntry";
    public static final String MEMBERSHIP_ATTRIBUTE_NAME = "membershipAttributeName";
    public static final String IS_MEMBERSHIP_ATTRIBUTE_DN = "isMembershipAttributeDN";
    public static final String ALLOW_EMPTY_MEMBERSHIPS = "allowEmptyMemberships";
    public static final String CREATE_ENTRY_ATTRIBUTE_VALUES = "createEntryAttributeValues";

    public SimpleLDAPIdentityObjectTypeConfiguration(IdentityObjectTypeMetaData objectTypeMD) {
        this.idAttributeName = objectTypeMD.getOptionSingleValue(ID_ATTRIBUTE_NAME);
        this.passwordAttributeName = objectTypeMD.getOptionSingleValue(PASSWORD_ATTRIBUTE_NAME);
        this.entrySearchFilter = objectTypeMD.getOptionSingleValue(ENTRY_SEARCH_FILTER);
        this.membershipAttributeName = objectTypeMD.getOptionSingleValue(MEMBERSHIP_ATTRIBUTE_NAME);
        String allowCreateEntry = objectTypeMD.getOptionSingleValue(ALLOW_CREATE_ENTRY);
        this.allowCreateEntry = allowCreateEntry != null && allowCreateEntry.equalsIgnoreCase("true");
        String isMembershipAttributeDN = objectTypeMD.getOptionSingleValue(IS_MEMBERSHIP_ATTRIBUTE_DN);
        this.isMembershipAttributeDN = isMembershipAttributeDN != null && isMembershipAttributeDN.equalsIgnoreCase("true");
        String allowEmptyMemberships = objectTypeMD.getOptionSingleValue(ALLOW_EMPTY_MEMBERSHIPS);
        this.allowEmptyMemberships = allowEmptyMemberships != null && allowEmptyMemberships.equalsIgnoreCase("true");
        LinkedList<String> relationships = new LinkedList<String>();
        if (objectTypeMD.getRelationships() != null) {
            for (RelationshipMetaData relationshipMetaData : objectTypeMD.getRelationships()) {
                relationships.add(relationshipMetaData.getIdentityObjectTypeRef());
            }
        }
        this.allowedMembershipTypes = relationships.toArray(new String[relationships.size()]);
        this.attributeNames = new HashMap<String, String>();
        for (IdentityObjectAttributeMetaData attributeMetaData : objectTypeMD.getAttributes()) {
            this.attributeNames.put(attributeMetaData.getName(), attributeMetaData.getStoreMapping());
        }
        List dns = objectTypeMD.getOption(CTX_DNS);
        this.ctxDNs = dns != null ? dns.toArray(new String[dns.size()]) : null;
        HashMap createEntryAttributesMap = new HashMap();
        List createAttributes = objectTypeMD.getOption(CREATE_ENTRY_ATTRIBUTE_VALUES);
        if (createAttributes != null && createAttributes.size() > 0) {
            for (String attribute : createAttributes) {
                String[] parts = attribute.split("=", 2);
                if (parts.length != 2) continue;
                String name = parts[0];
                String value = parts[1];
                if (!createEntryAttributesMap.containsKey(name)) {
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(value);
                    createEntryAttributesMap.put(name, list);
                    continue;
                }
                ((List)createEntryAttributesMap.get(name)).add(value);
            }
            HashMap<String, String[]> createEntryAttributesArray = new HashMap<String, String[]>();
            for (Map.Entry entry : createEntryAttributesMap.entrySet()) {
                createEntryAttributesArray.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            }
            this.createEntryAttributeValues = createEntryAttributesArray;
        } else {
            this.createEntryAttributeValues = new HashMap<String, String[]>();
        }
    }

    public SimpleLDAPIdentityObjectTypeConfiguration(String idAttributeName, String passwordAttributeName, String[] ctxDNs, String entrySearchFilter, boolean allowCreateEntry, Map<String, String[]> createEntryAttributeValues, String[] allowedMembershipTypes, String membershipAttributeName, boolean membershipAttributeDN, boolean allowEmptyMemberships, Map<String, String> attributeNames) {
        this.idAttributeName = idAttributeName;
        this.passwordAttributeName = passwordAttributeName;
        this.ctxDNs = ctxDNs;
        this.entrySearchFilter = entrySearchFilter;
        this.allowCreateEntry = allowCreateEntry;
        this.createEntryAttributeValues = createEntryAttributeValues;
        this.allowedMembershipTypes = allowedMembershipTypes;
        this.membershipAttributeName = membershipAttributeName;
        this.isMembershipAttributeDN = membershipAttributeDN;
        this.allowEmptyMemberships = allowEmptyMemberships;
        this.attributeNames = attributeNames;
    }

    @Override
    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    @Override
    public String[] getCtxDNs() {
        return this.ctxDNs;
    }

    @Override
    public String getEntrySearchFilter() {
        return this.entrySearchFilter;
    }

    @Override
    public boolean isAllowCreateEntry() {
        return this.allowCreateEntry;
    }

    @Override
    public Map<String, String[]> getCreateEntryAttributeValues() {
        return this.createEntryAttributeValues;
    }

    @Override
    public String[] getAllowedMembershipTypes() {
        return this.allowedMembershipTypes;
    }

    @Override
    public String getMembershipAttributeName() {
        return this.membershipAttributeName;
    }

    @Override
    public boolean isMembershipAttributeDN() {
        return this.isMembershipAttributeDN;
    }

    @Override
    public boolean allowEmptyMemberships() {
        return this.allowEmptyMemberships;
    }

    @Override
    public String getAttributeMapping(String name) {
        return this.attributeNames.get(name);
    }

    @Override
    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    @Override
    public Set<String> getMappedAttributesNames() {
        return Collections.unmodifiableSet(this.attributeNames.keySet());
    }
}

