/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.ldap;

import java.util.Hashtable;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

public class LDAPIdentityStoreSessionImpl
implements IdentityStoreSession {
    private final String INITIAL_CONTEXT_FACTORY;
    private final String PROVIDER_URL;
    private final String SECURITY_AUTHENTICATION;
    private final String SECURITY_PRINCIPAL;
    private final String SECURITY_CREDENTIALS;

    public LDAPIdentityStoreSessionImpl(String INITIAL_CONTEXT_FACTORY, String PROVIDER_URL, String SECURITY_AUTHENTICATION, String SECURITY_PRINCIPAL, String SECURITY_CREDENTIALS) {
        this.INITIAL_CONTEXT_FACTORY = INITIAL_CONTEXT_FACTORY;
        this.PROVIDER_URL = PROVIDER_URL;
        this.SECURITY_AUTHENTICATION = SECURITY_AUTHENTICATION;
        this.SECURITY_PRINCIPAL = SECURITY_PRINCIPAL;
        this.SECURITY_CREDENTIALS = SECURITY_CREDENTIALS;
    }

    public LdapContext getLdapContext() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", this.PROVIDER_URL);
        env.put("java.naming.security.authentication", this.SECURITY_AUTHENTICATION);
        env.put("java.naming.security.principal", this.SECURITY_PRINCIPAL);
        env.put("java.naming.security.credentials", this.SECURITY_CREDENTIALS);
        return new InitialLdapContext(env, null);
    }

    public Object getSessionContext() throws IdentityException {
        try {
            return this.getLdapContext();
        }
        catch (Exception e) {
            throw new IdentityException("Could not create LdapContext", (Throwable)e);
        }
    }

    public void close() throws IdentityException {
    }

    public void save() throws IdentityException {
    }

    public void clear() throws IdentityException {
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isTransactionSupported() {
        return false;
    }

    public void startTransaction() {
    }

    public void commitTransaction() {
    }

    public void rollbackTransaction() {
    }

    public boolean isTransactionActive() {
        return false;
    }
}

