/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.model;

public class GroupId {
    public static final String PREFIX = "group:/";
    private String name;
    private String type;

    public GroupId(String name, String type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.name = name;
        this.type = type;
    }

    public GroupId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        String[] parts = id.split("/");
        if (!GroupId.validateId(id)) {
            throw new IllegalArgumentException("group id not following required format: group/type/name: " + id);
        }
        this.name = parts[2];
        this.type = parts[1];
    }

    public static boolean validateId(String id) {
        String[] parts = id.split("/");
        return parts != null && parts.length == 3 && !parts[0].equals(PREFIX.substring(0, PREFIX.length()));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return PREFIX + this.type + "/" + this.name;
    }
}

