/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.LinkedList;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchControl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.impl.api.SimpleAttribute;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleUser;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;
import org.jboss.identity.idm.impl.api.session.context.IdentitySessionContext;
import org.jboss.identity.idm.impl.types.SimpleIdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.searchcontrol.IdentityObjectSearchControl;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;

public abstract class AbstractManager {
    protected final IdentitySession identitySession;

    protected AbstractManager(IdentitySession session) {
        this.identitySession = session;
    }

    public IdentitySession getIdentitySession() {
        return this.identitySession;
    }

    protected IdentitySessionContext getSessionContext() {
        if (this.identitySession instanceof IdentitySessionImpl) {
            return ((IdentitySessionImpl)this.identitySession).getSessionContext();
        }
        return null;
    }

    protected IdentityStoreRepository getRepository() {
        return this.getSessionContext().getIdentityStoreRepository();
    }

    protected IdentityStoreInvocationContext getInvocationContext() {
        return this.getSessionContext().resolveStoreInvocationContext();
    }

    protected User createUser(IdentityObject identityObject) {
        return new SimpleUser(identityObject.getName());
    }

    protected User createUserFromId(String name) {
        return new SimpleUser(name);
    }

    protected Group createGroup(IdentityObject identityObject) {
        String groupType = this.getSessionContext().getIdentityObjectTypeMapper().getGroupType(identityObject.getIdentityType());
        return new SimpleGroup(identityObject.getName(), groupType);
    }

    protected IdentityType createIdentityTypeFromId(String id) {
        if (GroupId.validateId(id)) {
            GroupId groupId = new GroupId(id);
            return new SimpleGroup(groupId);
        }
        return new SimpleUser(id);
    }

    protected IdentityObject createIdentityObject(User identity) {
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
        return new SimpleIdentityObject(identity.getId(), iot);
    }

    protected IdentityObject createIdentityObjectForUserName(String userName) {
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
        return new SimpleIdentityObject(userName, iot);
    }

    protected IdentityObject createIdentityObject(Group group) {
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(group.getGroupType());
        return new SimpleIdentityObject(group.getName(), group.getId(), iot);
    }

    protected IdentityObject createIdentityObjectForGroupId(String groupId) {
        GroupId id = new GroupId(groupId);
        IdentityObjectType iot = this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(id.getType());
        return new SimpleIdentityObject(id.getName(), null, iot);
    }

    protected IdentityObject createIdentityObject(IdentityType identityType) {
        if (identityType instanceof User) {
            return this.createIdentityObject((User)identityType);
        }
        if (identityType instanceof Group) {
            return this.createIdentityObject((Group)identityType);
        }
        throw new IllegalStateException("Not supported IdentityType extension: " + identityType.getClass());
    }

    protected IdentityObject createIdentityObject(String id) {
        if (GroupId.validateId(id)) {
            GroupId groupId = new GroupId(id);
            return this.createIdentityObjectForGroupId(id);
        }
        return this.createIdentityObjectForUserName(id);
    }

    protected Group createGroupFromId(String id) {
        return new SimpleGroup(new GroupId(id));
    }

    protected IdentityObjectSearchControl[] convertSearchControls(IdentitySearchControl[] controls) {
        if (controls == null) {
            return null;
        }
        LinkedList<IdentityObjectSearchControl> result = new LinkedList<IdentityObjectSearchControl>();
        for (IdentitySearchControl control : controls) {
            if (!(control instanceof IdentityObjectSearchControl)) continue;
            result.add((IdentityObjectSearchControl)control);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new IdentityObjectSearchControl[result.size()]);
    }

    protected IdentityObjectType getUserObjectType() {
        return this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
    }

    protected IdentityObjectType getIdentityObjectType(String groupType) {
        return this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
    }

    protected IdentityObjectAttribute[] convertAttributes(Attribute[] attributes) {
        IdentityObjectAttribute[] convertedAttributes = new IdentityObjectAttribute[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            convertedAttributes[i] = this.convertAttribute(attributes[i]);
        }
        return convertedAttributes;
    }

    protected Attribute[] convertAttributes(IdentityObjectAttribute[] attributes) {
        Attribute[] convertedAttributes = new Attribute[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            convertedAttributes[i] = this.convertAttribute(attributes[i]);
        }
        return convertedAttributes;
    }

    protected Attribute convertAttribute(IdentityObjectAttribute attribute) {
        if (attribute instanceof Attribute) {
            return (Attribute)attribute;
        }
        return new SimpleAttribute(attribute);
    }

    protected IdentityObjectAttribute convertAttribute(Attribute attribute) {
        if (attribute instanceof IdentityObjectAttribute) {
            return (IdentityObjectAttribute)attribute;
        }
        return new SimpleAttribute(attribute);
    }

    protected void checkNotNullArgument(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    protected void checkObjectName(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("name cannot contain '/' character");
        }
    }
}

