/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.model.hibernate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.jboss.identity.idm.impl.model.hibernate.HibernateRealm;

@Entity
@Table(name="identity_relationship_name", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "REALM"})})
public class HibernateIdentityObjectRelationshipName {
    public static final String findIdentityObjectRelationshipNameByName = "select rn from HibernateIdentityObjectRelationshipName rn where rn.name like :name and rn.realm like :realm";
    public static final String findIdentityObjectRelationshipNames = "select rn.name from HibernateIdentityObjectRelationshipName rn where rn.name like :nameFilter and rn.realm like :realm";
    public static final String findIdentityObjectRelationshipNamesOrderedByNameAsc = "select rn.name from HibernateIdentityObjectRelationshipName rn where rn.name like :nameFilter and rn.realm like :realm order by rn.name asc";
    public static final String findIdentityObjectRelationshipNamesOrderedByNameDesc = "select rn.name from HibernateIdentityObjectRelationshipName rn where rn.name like :nameFilter and rn.realm like :realm order by rn.name desc";
    public static final String findIdentityObjectRelationshipNamesForIdentityObject = "select r.name.name from HibernateIdentityObjectRelationship r where r.fromIdentityObject like :identityObject or r.toIdentityObject like :identityObject";
    public static final String findIdentityObjectRelationshipNamesForIdentityObjectOrderedByNameAsc = "select r.name.name from HibernateIdentityObjectRelationship r where r.fromIdentityObject like :identityObject or r.toIdentityObject like :identityObject order by r.name.name asc";
    public static final String findIdentityObjectRelationshipNamesForIdentityObjectOrdereByNameDesc = "select r.name.name from HibernateIdentityObjectRelationship r where r.fromIdentityObject like :identityObject or r.toIdentityObject like :identityObject order by r.name.name desc";
    @Id
    @GeneratedValue
    private Long id;
    @Column(nullable=false, unique=true, name="NAME")
    private String name;
    @ManyToOne
    @JoinColumn(nullable=false, name="REALM")
    private HibernateRealm realm;

    public HibernateIdentityObjectRelationshipName() {
    }

    public HibernateIdentityObjectRelationshipName(String name, HibernateRealm realm) {
        this.name = name;
        this.realm = realm;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HibernateRealm getRealm() {
        return this.realm;
    }

    public void setRealm(HibernateRealm realm) {
        this.realm = realm;
    }
}

