/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.model;

public class GroupId {
    public static final String PREFIX = "jbpid_group_id";
    public static final String SEPARATOR = "_._._";
    public static final String SEPARATOR_REGEX = "_\\._\\._";
    private String name;
    private String type;

    public GroupId(String name, String type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.name = name;
        this.type = type;
    }

    public GroupId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        String[] parts = id.split(SEPARATOR_REGEX);
        if (!GroupId.validateId(id)) {
            throw new IllegalArgumentException("group id not following required format: jbpid_group_id_._._groupType_._._name : " + id);
        }
        this.name = parts[2];
        this.type = parts[1];
    }

    public static boolean validateId(String id) {
        String[] parts = id.split(SEPARATOR_REGEX);
        return parts != null && parts.length == 3 && !parts[0].equals(PREFIX.substring(0, PREFIX.length() - 1));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return "jbpid_group_id_._._" + this.type + SEPARATOR + this.name;
    }
}

