/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.query.GroupQuery;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleUser;
import org.jboss.identity.idm.impl.api.query.AbstractQuery;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupQueryImpl
extends AbstractQuery
implements GroupQuery {
    private GroupId groupId;
    private String groupName;
    private String groupType;
    private Set<Group> associatedParentGroups = new HashSet<Group>();
    private Set<Group> associatedChildGroups = new HashSet<Group>();
    private Set<User> usersAssociated = new HashSet<User>();
    private Set<User> usersRelated = new HashSet<User>();
    private Set<User> usersConnectedByRole = new HashSet<User>();

    public GroupQueryImpl(IdentitySessionImpl identitySession) {
        super(identitySession);
    }

    public Collection<Group> execute() throws QueryException {
        this.prepare();
        throw new NotYetImplementedException();
    }

    private void prepare() {
        if (this.groupId == null && this.groupName != null && this.groupType != null) {
            this.groupId = new GroupId(this.groupName, this.groupType);
        }
    }

    public Group uniqueResult() throws QueryException {
        throw new NotYetImplementedException();
    }

    public List<Group> list() throws QueryException {
        throw new NotYetImplementedException();
    }

    public GroupQuery setId(String id) {
        this.groupId = new GroupId(id);
        return this;
    }

    public GroupQuery setNameAndType(String name, String type) {
        this.groupId = new GroupId(name, type);
        this.groupName = name;
        this.groupType = type;
        return this;
    }

    public GroupQuery setName(String name) {
        this.checkNotNullArgument(name, "Group name");
        this.groupName = name;
        return this;
    }

    public GroupQuery setType(String type) {
        this.checkNotNullArgument(type, "Group type");
        this.groupType = type;
        return this;
    }

    public GroupQuery addAssociatedGroup(Group group, boolean parent) {
        this.checkNotNullArgument(group, "Group");
        if (parent) {
            this.associatedParentGroups.add(group);
        } else {
            this.associatedChildGroups.add(group);
        }
        return this;
    }

    public GroupQuery addAssociatedGroup(String id, boolean parent) {
        this.checkNotNullArgument(id, "Group id");
        SimpleGroup group = new SimpleGroup(new GroupId(id));
        if (parent) {
            this.associatedParentGroups.add(group);
        } else {
            this.associatedChildGroups.add(group);
        }
        return this;
    }

    public GroupQuery addAssociatedGroups(Collection<Group> groups, boolean parent) {
        this.checkNotNullArgument(groups, "Groups");
        if (parent) {
            this.associatedParentGroups.addAll(groups);
        } else {
            this.associatedChildGroups.addAll(groups);
        }
        return this;
    }

    public GroupQuery addAssociatedGroupsIds(Collection<String> ids, boolean parent) {
        this.checkNotNullArgument(ids, "Groups ids");
        for (String groupId : ids) {
            SimpleGroup group = new SimpleGroup(new GroupId(groupId));
            if (parent) {
                this.associatedParentGroups.add(group);
                continue;
            }
            this.associatedChildGroups.add(group);
        }
        return this;
    }

    public GroupQuery addAssociatedUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.usersAssociated.add(user);
        return this;
    }

    public GroupQuery addAssociatedUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.usersAssociated.add(new SimpleUser(id));
        return this;
    }

    public GroupQuery addAssociatedUsers(Collection<User> users) {
        this.checkNotNullArgument(users, "Users");
        this.usersAssociated.addAll(users);
        return this;
    }

    public GroupQuery addAssociatedUsersIds(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Users ids");
        for (String id : ids) {
            this.usersAssociated.add(new SimpleUser(id));
        }
        return this;
    }

    public GroupQuery addUserConnectedByRole(User user) {
        this.checkNotNullArgument(user, "User");
        this.usersConnectedByRole.add(user);
        return this;
    }

    public GroupQuery addUserConnectedByRole(String id) {
        this.checkNotNullArgument(id, "User id");
        this.usersConnectedByRole.add(new SimpleUser(id));
        return this;
    }

    public GroupQuery addUsersConnectedByRole(Collection<User> users) {
        this.checkNotNullArgument(users, "Users");
        this.usersConnectedByRole.addAll(users);
        return this;
    }

    public GroupQuery addUsersIdsConnectedByRole(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Users ids");
        for (String id : ids) {
            this.usersConnectedByRole.add(new SimpleUser(id));
        }
        return this;
    }

    public GroupQuery addRelatedUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.usersRelated.add(user);
        return this;
    }

    public GroupQuery addRelatedUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.usersRelated.add(new SimpleUser(id));
        return this;
    }

    public GroupQuery sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (GroupQuery)super.sort(order);
    }

    public GroupQuery sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (GroupQuery)super.sortAttributeName(name);
    }

    public GroupQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (GroupQuery)super.page(firstResult, maxResults);
    }

    public GroupQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (GroupQuery)super.attributeValuesFilter(attributeName, attributeValue);
    }
}

