/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.api.query.UserQuery;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.query.AbstractQuery;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserQueryImpl
extends AbstractQuery
implements UserQuery {
    private String userId;
    private Set<Group> groupsAssociatedWith = new HashSet<Group>();
    private Set<Group> groupsConnectedWithRole = new HashSet<Group>();
    private Set<Group> groupsRelated = new HashSet<Group>();

    public UserQueryImpl(IdentitySessionImpl identitySession) {
        super(identitySession);
    }

    public Collection<User> execute() throws QueryException {
        throw new NotYetImplementedException();
    }

    public User uniqueResult() throws QueryException {
        throw new NotYetImplementedException();
    }

    public List<User> list() throws QueryException {
        throw new NotYetImplementedException();
    }

    public UserQuery withUserId(String id) {
        this.checkNotNullArgument(id, "User id");
        this.userId = id;
        return this;
    }

    public UserQuery addAssociatedGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsAssociatedWith.add(group);
        return this;
    }

    public UserQuery addAssociatedGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsAssociatedWith.add(this.createGroupFromId(id));
        return this;
    }

    public UserQuery addAssociatedGroups(Collection<Group> groups) {
        this.checkNotNullArgument(groups, "Groups");
        this.groupsAssociatedWith.addAll(groups);
        return this;
    }

    public UserQuery addAssociatedGroupsIds(Collection<String> groups) {
        this.checkNotNullArgument(groups, "Groups");
        for (String groupId : groups) {
            this.groupsAssociatedWith.add(this.createGroupFromId(groupId));
        }
        return this;
    }

    public UserQuery addGroupConnectedWithRole(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsConnectedWithRole.add(group);
        return this;
    }

    public UserQuery addGroupConnectedWithRole(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsConnectedWithRole.add(this.createGroupFromId(id));
        return this;
    }

    public UserQuery addGroupsConnectedWithRole(Collection<Group> groups) {
        this.checkNotNullArgument(groups, "Groups");
        this.groupsConnectedWithRole.addAll(groups);
        return this;
    }

    public UserQuery addGroupsIdsConnectedWithRole(Collection<String> groups) {
        this.checkNotNullArgument(groups, "Groups");
        for (String groupId : groups) {
            this.groupsConnectedWithRole.add(this.createGroupFromId(groupId));
        }
        return this;
    }

    public UserQuery addRelatedGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsRelated.add(group);
        return this;
    }

    public UserQuery addRelatedGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.groupsRelated.add(this.createGroupFromId(id));
        return this;
    }

    public UserQuery addRelatedGroups(Collection<Group> group) {
        this.checkNotNullArgument(group, "Group");
        this.groupsRelated.addAll(group);
        return this;
    }

    public UserQuery addRelatedGroupsIds(Collection<String> ids) {
        this.checkNotNullArgument(ids, "Groups ids");
        for (String id : ids) {
            this.groupsRelated.add(this.createGroupFromId(id));
        }
        return this;
    }

    public UserQuery sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (UserQuery)super.sort(order);
    }

    public UserQuery sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (UserQuery)super.sortAttributeName(name);
    }

    public UserQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (UserQuery)super.page(firstResult, maxResults);
    }

    public UserQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (UserQuery)super.attributeValuesFilter(attributeName, attributeValue);
    }
}

