/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.model.hibernate;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.CollectionOfElements;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObject;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="jbid_io_creden", uniqueConstraints={@UniqueConstraint(columnNames={"IDENTITY_OBJECT_TYPE", "IDENTITY_OBJECT_ID"})})
public class HibernateIdentityObjectCredential
implements IdentityObjectCredential {
    public static final String findIdentityObjectCredentialByIOAndTypeNAme = "select c from HibernateIdentityObjectCredential c where c.type.name like :typeName and c.identityObject = :identityObject";
    @Id
    @GeneratedValue
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="IDENTITY_OBJECT_TYPE", nullable=false)
    private HibernateIdentityObjectCredentialType type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="IDENTITY_OBJECT_ID", nullable=false)
    private HibernateIdentityObject identityObject;
    @Column(name="TEXT", nullable=true)
    private String textValue;
    @Column(name="BINARY_VALUE", nullable=true, length=10240000)
    private byte[] binaryValue;
    @CollectionOfElements
    @JoinTable(name="jbid_io_creden_props", joinColumns={@JoinColumn(name="CREDENTIAL_ID")})
    @Column(name="PROPERTY")
    private Map<String, String> properties = new HashMap<String, String>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(byte[] binaryValue) {
        this.binaryValue = binaryValue;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public HibernateIdentityObjectCredentialType getType() {
        return this.type;
    }

    public void setType(HibernateIdentityObjectCredentialType type) {
        this.type = type;
    }

    public HibernateIdentityObject getIdentityObject() {
        return this.identityObject;
    }

    public void setIdentityObject(HibernateIdentityObject identityObject) {
        this.identityObject = identityObject;
    }

    public Object getValue() {
        if (this.textValue != null) {
            return this.textValue;
        }
        return this.binaryValue;
    }

    public Object getEncodedValue() {
        return null;
    }
}

