/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.api.query;

import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.SortOrder;

import java.util.Collection;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public interface GroupQueryBuilder extends QueryBuilder
{
   GroupQuery createQuery();

   GroupQueryBuilder reset();

   GroupQueryBuilder setId(String id);

   GroupQueryBuilder setNameAndType(String name, String type);

   GroupQueryBuilder setName(String name);

   GroupQueryBuilder setType(String type);

   GroupQueryBuilder addAssociatedGroup(Group group, boolean parent);

   GroupQueryBuilder addAssociatedGroup(String id, boolean parent);

   GroupQueryBuilder addAssociatedGroups(Collection<Group> groups, boolean parent);

   GroupQueryBuilder addAssociatedGroupsIds(Collection<String> ids, boolean parent);

   GroupQueryBuilder addAssociatedUser(User user);

   GroupQueryBuilder addAssociatedUser(String id);

   GroupQueryBuilder addAssociatedUsers(Collection<User> users);

   GroupQueryBuilder addAssociatedUsersIds(Collection<String> ids);

   GroupQueryBuilder addUserConnectedByRole(User user);

   GroupQueryBuilder addUserConnectedByRole(String id);

   GroupQueryBuilder addUsersConnectedByRole(Collection<User> users);

   GroupQueryBuilder addUsersIdsConnectedByRole(Collection<String> ids);

   GroupQueryBuilder addRelatedUser(User user);

   GroupQueryBuilder addRelatedUser(String id);

   GroupQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium;

   GroupQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium;

   GroupQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium;

   GroupQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium;

}
