/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.hibernate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObject;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectBinaryAttribute;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectBinaryAttributeValue;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipName;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectTextAttribute;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.jboss.identity.idm.impl.model.hibernate.HibernateRealm;
import org.jboss.identity.idm.impl.store.FeaturesMetaDataImpl;
import org.jboss.identity.idm.impl.store.hibernate.HibernateIdentityStoreSessionImpl;
import org.jboss.identity.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;
import org.jboss.identity.idm.spi.model.IdentityObjectCredentialType;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;
import org.jboss.identity.idm.spi.store.FeaturesMetaData;
import org.jboss.identity.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.jboss.identity.idm.spi.store.IdentityStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateIdentityStoreImpl
implements IdentityStore,
Serializable {
    private final String QUERY_RELATIONSHIP_BY_FROM_TO = "select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO";
    private final String QUERY_RELATIONSHIP_BY_FROM_TO_TYPE = "select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName";
    private final String QUERY_RELATIONSHIP_BY_FROM_TO_TYPE_NAME = "select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName and r.name.name like :name";
    private final String QUERY_RELATIONSHIP_BY_IDENTITIES = "select r from HibernateIdentityObjectRelationship r where (r.fromIdentityObject = :IO1 and r.toIdentityObject = :IO2) or (r.fromIdentityObject = :IO2 and r.toIdentityObject = :IO1)";
    public static final String HIBERNATE_SESSION_FACTORY_REGISTRY_NAME = "hibernateSessionFactoryRegistryName";
    public static final String HIBERNATE_CONFIGURATION = "hibernateConfiguration";
    public static final String ADD_MAPPED_CLASSES = "addMappedClasses";
    public static final String HIBERNATE_SESSION_FACTORY_JNDI_NAME = "hibernateSessionFactoryJNDIName";
    public static final String POPULATE_MEMBERSHIP_TYPES = "populateRelationshipTypes";
    public static final String POPULATE_IDENTITY_OBJECT_TYPES = "populateIdentityObjectTypes";
    public static final String IS_REALM_AWARE = "isRealmAware";
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    public static final String DEFAULT_REALM_NAME = HibernateIdentityStoreImpl.class.getName() + ".DEFAULT_REALM";
    public static final String CREDENTIAL_TYPE_PASSWORD = "PASSWORD";
    public static final String CREDENTIAL_TYPE_BINARY = "BINARY";
    private String id;
    private FeaturesMetaData supportedFeatures;
    private SessionFactory sessionFactory;
    private boolean isRealmAware = false;
    private boolean isAllowNotDefinedAttributes = false;
    private IdentityStoreConfigurationMetaData configurationMD;
    private static Set<IdentityObjectSearchCriteriaType> supportedIdentityObjectSearchCriteria = new HashSet<IdentityObjectSearchCriteriaType>();
    private static Set<String> supportedCredentialTypes = new HashSet<String>();
    private Map<String, Set<String>> attributeMappings = new HashMap<String, Set<String>>();
    private Map<String, Map<String, IdentityObjectAttributeMetaData>> attributesMetaData = new HashMap<String, Map<String, IdentityObjectAttributeMetaData>>();
    private Map<String, Map<String, String>> reverseAttributeMappings = new HashMap<String, Map<String, String>>();
    private static final long serialVersionUID = -130355852189832805L;

    public HibernateIdentityStoreImpl(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String allowNotDefineAttributes;
        String realmAware;
        this.configurationMD = configurationContext.getStoreConfigurationMetaData();
        this.id = this.configurationMD.getId();
        this.supportedFeatures = new FeaturesMetaDataImpl(this.configurationMD, supportedIdentityObjectSearchCriteria, true, true, new HashSet());
        String populateMembershipTypes = this.configurationMD.getOptionSingleValue(POPULATE_MEMBERSHIP_TYPES);
        String populateIdentityObjectTypes = this.configurationMD.getOptionSingleValue(POPULATE_IDENTITY_OBJECT_TYPES);
        this.sessionFactory = this.bootstrapHibernateSessionFactory(configurationContext);
        Session hibernateSession = this.sessionFactory.openSession();
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : this.configurationMD.getSupportedIdentityTypes()) {
            HashSet<String> names = new HashSet<String>();
            HashMap<String, IdentityObjectAttributeMetaData> metadataMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            HashMap<String, String> reverseMap = new HashMap<String, String>();
            for (IdentityObjectAttributeMetaData attributeMetaData : identityObjectTypeMetaData.getAttributes()) {
                names.add(attributeMetaData.getName());
                metadataMap.put(attributeMetaData.getName(), attributeMetaData);
                if (attributeMetaData.getStoreMapping() == null) continue;
                reverseMap.put(attributeMetaData.getStoreMapping(), attributeMetaData.getName());
            }
            this.attributeMappings.put(identityObjectTypeMetaData.getName(), Collections.unmodifiableSet(names));
            this.attributesMetaData.put(identityObjectTypeMetaData.getName(), metadataMap);
            this.reverseAttributeMappings.put(identityObjectTypeMetaData.getName(), reverseMap);
        }
        this.attributeMappings = Collections.unmodifiableMap(this.attributeMappings);
        if (populateMembershipTypes != null && populateMembershipTypes.equalsIgnoreCase("true")) {
            LinkedList<String> memberships = new LinkedList<String>();
            for (String membership : this.configurationMD.getSupportedRelationshipTypes()) {
                memberships.add(membership);
            }
            try {
                this.populateRelationshipTypes((org.hibernate.Session)hibernateSession, memberships.toArray(new String[memberships.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populate relationship types", (Throwable)e);
            }
        }
        if (populateIdentityObjectTypes != null && populateIdentityObjectTypes.equalsIgnoreCase("true")) {
            LinkedList<String> types = new LinkedList<String>();
            for (IdentityObjectTypeMetaData metaData : this.configurationMD.getSupportedIdentityTypes()) {
                types.add(metaData.getName());
            }
            try {
                this.populateObjectTypes((org.hibernate.Session)hibernateSession, types.toArray(new String[types.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populate identity object types", (Throwable)e);
            }
        }
        if (supportedCredentialTypes != null && supportedCredentialTypes.size() > 0) {
            try {
                this.populateCredentialTypes((org.hibernate.Session)hibernateSession, supportedCredentialTypes.toArray(new String[supportedCredentialTypes.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populated credential types");
            }
        }
        if ((realmAware = this.configurationMD.getOptionSingleValue(IS_REALM_AWARE)) != null && realmAware.equalsIgnoreCase("true")) {
            this.isRealmAware = true;
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedAttributes = true;
        }
        HibernateRealm realm = null;
        try {
            hibernateSession.getTransaction().begin();
            realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)DEFAULT_REALM_NAME)).uniqueResult();
            hibernateSession.getTransaction().commit();
        }
        catch (HibernateException e) {
            // empty catch block
        }
        if (realm == null) {
            this.addRealm((org.hibernate.Session)hibernateSession, DEFAULT_REALM_NAME);
        }
        hibernateSession.flush();
        hibernateSession.close();
    }

    protected SessionFactory bootstrapHibernateSessionFactory(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String sfJNDIName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_JNDI_NAME);
        String sfRegistryName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_REGISTRY_NAME);
        String addMappedClasses = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(ADD_MAPPED_CLASSES);
        String hibernateConfiguration = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_CONFIGURATION);
        if (sfJNDIName != null) {
            try {
                return (SessionFactory)new InitialContext().lookup(sfJNDIName);
            }
            catch (NamingException e) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided JNDI name: " + sfJNDIName, (Throwable)e);
            }
        }
        if (sfRegistryName != null) {
            Object registryObject = configurationContext.getConfigurationRegistry().getObject(sfRegistryName);
            if (registryObject == null) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName);
            }
            if (!(registryObject instanceof SessionFactory)) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName + "; Registered object is not an instance of SessionFactory: " + registryObject.getClass().getName());
            }
            return (SessionFactory)registryObject;
        }
        if (hibernateConfiguration != null) {
            try {
                AnnotationConfiguration config = new AnnotationConfiguration().configure(hibernateConfiguration);
                if (addMappedClasses != null && addMappedClasses.equals("false")) {
                    return config.buildSessionFactory();
                }
                return config.addAnnotatedClass(HibernateIdentityObject.class).addAnnotatedClass(HibernateIdentityObjectAttribute.class).addAnnotatedClass(HibernateIdentityObjectBinaryAttribute.class).addAnnotatedClass(HibernateIdentityObjectBinaryAttributeValue.class).addAnnotatedClass(HibernateIdentityObjectTextAttribute.class).addAnnotatedClass(HibernateIdentityObjectCredential.class).addAnnotatedClass(HibernateIdentityObjectCredentialType.class).addAnnotatedClass(HibernateIdentityObjectRelationship.class).addAnnotatedClass(HibernateIdentityObjectRelationshipName.class).addAnnotatedClass(HibernateIdentityObjectRelationshipType.class).addAnnotatedClass(HibernateIdentityObjectType.class).addAnnotatedClass(HibernateRealm.class).buildSessionFactory();
            }
            catch (Exception e) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory using provided hibernate configuration: " + hibernateConfiguration, (Throwable)e);
            }
        }
        throw new IdentityException("Cannot obtain hibernate SessionFactory. None of supported options specified: hibernateSessionFactoryJNDIName, hibernateSessionFactoryRegistryName, hibernateConfiguration");
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        try {
            return new HibernateIdentityStoreSessionImpl(this.sessionFactory);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to obtain Hibernate SessionFactory", (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(identityObjectType);
        org.hibernate.Session session = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(session, ctx);
        List results = session.createQuery("select o from HibernateIdentityObject o where o.realm = :realm and o.name like :name and o.identityType.name like :typeName").setParameter("realm", (Object)realm).setParameter("name", (Object)name).setParameter("typeName", (Object)identityObjectType.getName()).list();
        if (results.size() != 0) {
            throw new IdentityException("IdentityObject already present in this IdentityStore:name=" + name + "; type=" + identityObjectType.getName() + "; realm=" + realm);
        }
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityObjectType);
        HibernateIdentityObject io = new HibernateIdentityObject(name, hibernateType, realm);
        if (attributes != null) {
            for (Map.Entry<String, String[]> entry : attributes.entrySet()) {
                io.addTextAttribute(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.getHibernateSession(ctx).persist((Object)io);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot persist new IdentityObject" + io, (Throwable)e);
        }
        return io;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            for (HibernateIdentityObjectRelationship relationship : hibernateObject.getFromRelationships()) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.delete((Object)relationship);
            }
            for (HibernateIdentityObjectRelationship relationship : hibernateObject.getToRelationships()) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.delete((Object)relationship);
            }
            hibernateSession.delete((Object)hibernateObject);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot remove IdentityObject" + identity, (Throwable)e);
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        int count;
        this.checkIOType(identityType);
        HibernateIdentityObjectType jpaType = this.getHibernateIdentityObjectType(ctx, identityType);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            count = ((Number)hibernateSession.createQuery("select count(o.id) from HibernateIdentityObject o where o.realm = :realm and o.identityType.name like :typeName").setParameter("typeName", (Object)jpaType.getName()).setParameter("realm", (Object)this.getRealm(hibernateSession, ctx)).uniqueResult()).intValue();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot count stored IdentityObjects with type: " + identityType.getName(), (Throwable)e);
        }
        return count;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType type) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(type);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, type);
        HibernateIdentityObject hibernateObject = null;
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            hibernateObject = (HibernateIdentityObject)this.getHibernateSession(ctx).createQuery("select o from HibernateIdentityObject o where o.realm = :realm and o.name like :name and o.identityType.name like :typeName").setParameter("realm", (Object)this.getRealm(em, ctx)).setParameter("name", (Object)name).setParameter("typeName", (Object)hibernateType.getName()).uniqueResult();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObject with name '" + name + "' and type '" + type.getName() + "'", (Throwable)e);
        }
        return hibernateObject;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        HibernateIdentityObject hibernateObject;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        try {
            hibernateObject = (HibernateIdentityObject)this.getHibernateSession(ctx).get(HibernateIdentityObject.class, (Serializable)new Long(id));
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObject with id: " + id, (Throwable)e);
        }
        return hibernateObject;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        List results;
        this.checkIOType(identityType);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityType);
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        try {
            Query q = null;
            q = criteria != null && criteria.isSorted() ? (criteria.isAscending() ? hibernateSession.createQuery("select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm = :realm and o.identityType.name like :typeName order by o.name asc") : hibernateSession.createQuery("select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm = :realm and o.identityType.name like :typeName order by o.name desc")) : hibernateSession.createQuery("select o from HibernateIdentityObject o where o.name like :nameFilter and o.realm = :realm and o.identityType.name like :typeName");
            if (criteria != null && criteria.isPaged()) {
                if (criteria.getMaxResults() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
                q.setFirstResult(criteria.getFirstResult());
            }
            q.setParameter("realm", (Object)this.getRealm(hibernateSession, ctx)).setParameter("typeName", (Object)hibernateType.getName());
            if (criteria != null && criteria.getFilter() != null) {
                q.setParameter("nameFilter", (Object)criteria.getFilter().replaceAll("\\*", "%"));
            } else {
                q.setParameter("nameFilter", (Object)"%");
            }
            results = q.list();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObjects with type '" + identityType.getName() + "'", (Throwable)e);
        }
        if (criteria != null && criteria.isFiltered()) {
            this.filterByAttributesValues(results, criteria.getValues());
        }
        return results;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        return this.findIdentityObject(ctx, identityType, null);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        List results;
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        boolean orderByName = false;
        boolean ascending = true;
        if (criteria != null && criteria.isSorted()) {
            orderByName = true;
            ascending = criteria.isAscending();
        }
        try {
            Query q = null;
            StringBuilder hqlString = new StringBuilder("");
            if (parent) {
                if (relationshipType != null) {
                    hqlString.append("select distinct ior.toIdentityObject from HibernateIdentityObjectRelationship ior where ior.toIdentityObject.name like :nameFilter and ior.type.name like :relType and ior.fromIdentityObject = :identity");
                } else {
                    hqlString.append("select distinct ior.toIdentityObject from HibernateIdentityObjectRelationship ior where ior.toIdentityObject.name like :nameFilter and ior.fromIdentityObject = :identity");
                }
                if (orderByName) {
                    hqlString.append(" orderBy ior.toIdentityObject.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            } else {
                if (relationshipType != null) {
                    hqlString.append("select distinct ior.fromIdentityObject from HibernateIdentityObjectRelationship ior where ior.fromIdentityObject.name like :nameFilter and ior.type.name like :relType and ior.toIdentityObject = :identity");
                } else {
                    hqlString.append("select distinct ior.fromIdentityObject from HibernateIdentityObjectRelationship ior where ior.fromIdentityObject.name like :nameFilter and ior.toIdentityObject = :identity");
                }
                if (orderByName) {
                    hqlString.append(" orderBy ior.toIdentityObject.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            }
            q = this.getHibernateSession(ctx).createQuery(hqlString.toString()).setParameter("identity", (Object)hibernateObject);
            if (relationshipType != null) {
                q.setParameter("relType", (Object)relationshipType.getName());
            }
            if (criteria != null && criteria.getFilter() != null) {
                q.setParameter("nameFilter", (Object)criteria.getFilter().replaceAll("\\*", "%"));
            } else {
                q.setParameter("nameFilter", (Object)"%");
            }
            if (criteria != null && criteria.isPaged()) {
                q.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
            }
            results = q.list();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObjects", (Throwable)e);
        }
        if (criteria != null && criteria.isFiltered()) {
            this.filterByAttributesValues(results, criteria.getValues());
        }
        return results;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent) throws IdentityException {
        return this.findIdentityObject(ctx, identity, relationshipType, parent, null);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name, boolean createNames) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        if (!this.getSupportedFeatures().isRelationshipTypeSupported((IdentityObjectType)fromIO.getIdentityType(), (IdentityObjectType)toIO.getIdentityType(), relationshipType)) {
            throw new IdentityException("Relationship not supported. RelationshipType[ " + relationshipType.getName() + " ] " + "beetween: [ " + fromIO.getIdentityType().getName() + " ] and [ " + toIO.getIdentityType().getName() + " ]");
        }
        Query query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName and r.name.name like :name").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName()).setParameter("name", (Object)name);
        List results = query.list();
        if (results.size() != 0) {
            throw new IdentityException("Relationship already present");
        }
        HibernateIdentityObjectRelationship relationship = null;
        if (name != null) {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO, relationshipName);
        } else {
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO);
        }
        this.getHibernateSession(ctx).persist((Object)relationship);
        return relationship;
    }

    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        this.getSupportedFeatures().isRelationshipTypeSupported((IdentityObjectType)fromIO.getIdentityType(), (IdentityObjectType)toIO.getIdentityType(), relationshipType);
        Query query = null;
        if (name == null) {
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName());
        } else {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName and r.name.name like :name").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName()).setParameter("name", (Object)name);
        }
        List results = query.list();
        if (results == null) {
            throw new IdentityException("Relationship already present");
        }
        HibernateIdentityObjectRelationship relationship = (HibernateIdentityObjectRelationship)results.iterator().next();
        fromIO.getFromRelationships().remove(relationship);
        toIO.getToRelationships().remove(relationship);
        this.getHibernateSession(ctx).delete((Object)relationship);
    }

    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, identity1);
        HibernateIdentityObject hio2 = this.safeGet(ctx, identity2);
        Query query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where (r.fromIdentityObject = :IO1 and r.toIdentityObject = :IO2) or (r.fromIdentityObject = :IO2 and r.toIdentityObject = :IO1)").setParameter("IO1", (Object)hio1).setParameter("IO2", (Object)hio2);
        List results = query.list();
        for (HibernateIdentityObjectRelationship relationship : results) {
            if ((!named || relationship.getName() == null) && (named || relationship.getName() != null)) continue;
            relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
            relationship.getToIdentityObject().getToRelationships().remove(relationship);
            this.getHibernateSession(ctx).delete((Object)relationship);
        }
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject hio2 = this.safeGet(ctx, toIdentity);
        Query query = null;
        query = relationshipType == null ? this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO") : this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName").setParameter("typeName", (Object)relationshipType.getName());
        query.setParameter("fromIO", (Object)hio1).setParameter("toIO", (Object)hio2);
        List results = query.list();
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name) throws IdentityException {
        HibernateIdentityObject hio = this.safeGet(ctx, identity);
        Criteria criteria = this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationship.class);
        if (type != null) {
            HibernateIdentityObjectRelationshipType hibernateType = this.getHibernateIdentityObjectRelationshipType(ctx, type);
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)hibernateType));
        }
        if (name != null) {
            criteria.add((Criterion)Restrictions.eq((String)"name.name", (Object)name));
        } else if (named) {
            criteria.add(Restrictions.isNotNull((String)"name"));
        } else {
            criteria.add(Restrictions.isNull((String)"name"));
        }
        if (parent) {
            criteria.add((Criterion)Restrictions.eq((String)"fromIdentityObject", (Object)hio));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"toIdentityObject", (Object)hio));
        }
        List results = criteria.list();
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session em = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(em, ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)em.createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"realm", (Object)realm)).uniqueResult();
            if (hiorn != null) {
                throw new IdentityException("Relationship name already exists");
            }
            hiorn = new HibernateIdentityObjectRelationshipName(name, realm);
            this.getHibernateSession(ctx).persist((Object)hiorn);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot create new relationship name: " + name, (Throwable)e);
        }
        return name;
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)em.createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"realm", (Object)this.getRealm(em, ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            this.getHibernateSession(ctx).delete((Object)hiorn);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot create new relationship name: " + name, (Throwable)e);
        }
        return name;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> names = null;
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            Query q = null;
            q = criteria != null && criteria.isSorted() ? (criteria.isAscending() ? em.createQuery("select rn.name from HibernateIdentityObjectRelationshipName rn where rn.name like :nameFilter and rn.realm = :realm order by rn.name asc") : em.createQuery("select rn.name from HibernateIdentityObjectRelationshipName rn where rn.name like :nameFilter and rn.realm = :realm order by rn.name desc")) : em.createQuery("select rn.name from HibernateIdentityObjectRelationshipName rn where rn.name like :nameFilter and rn.realm = :realm");
            q.setParameter("realm", (Object)this.getRealm(em, ctx));
            if (criteria != null && criteria.getFilter() != null) {
                q.setParameter("nameFilter", (Object)criteria.getFilter().replaceAll("\\*", "%"));
            } else {
                q.setParameter("nameFilter", (Object)"%");
            }
            if (criteria != null && criteria.isPaged()) {
                q.setFirstResult(criteria.getMaxResults());
                if (criteria.getFirstResult() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
            }
            List results = q.list();
            names = new HashSet<String>(results);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
        return names;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx) throws IdentityException, OperationNotSupportedException {
        return this.getRelationshipNames(ctx, (IdentityObjectSearchCriteria)null);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> names;
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            Query q = null;
            q = criteria != null ? (criteria.isAscending() ? em.createQuery("select r.name.name from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :identityObject or r.toIdentityObject = :identityObject order by r.name.name asc") : em.createQuery("select r.name.name from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :identityObject or r.toIdentityObject = :identityObject order by r.name.name desc")) : em.createQuery("select r.name.name from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :identityObject or r.toIdentityObject = :identityObject");
            q.setParameter("identityObject", (Object)hibernateObject);
            if (criteria != null && criteria.isPaged()) {
                q.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
            }
            List results = q.list();
            names = new HashSet<String>(results);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
        return names;
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException, OperationNotSupportedException {
        return this.getRelationshipNames(ctx, identity, null);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)em.createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"realm", (Object)this.getRealm(em, ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            return new HashMap<String, String>(hiorn.getProperties());
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship name properties: " + name, (Throwable)e);
        }
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)em.createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"realm", (Object)this.getRealm(em, ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            hiorn.getProperties().putAll(properties);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot set relationship name properties: " + name, (Throwable)e);
        }
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = (HibernateIdentityObjectRelationshipName)em.createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"realm", (Object)this.getRealm(em, ctx))).uniqueResult();
            if (hiorn == null) {
                throw new IdentityException("Relationship name doesn't exist");
            }
            for (String property : properties) {
                hiorn.getProperties().remove(property);
            }
        }
        catch (Exception e) {
            throw new IdentityException("Cannot remove relationship name properties: " + name, (Throwable)e);
        }
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        Query query = null;
        if (relationship.getName() == null) {
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName());
        } else {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)relationship.getName())).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName and r.name.name like :name").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName()).setParameter("name", (Object)relationship.getName());
        }
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = (HibernateIdentityObjectRelationship)query.uniqueResult();
            return new HashMap<String, String>(hibernateRelationship.getProperties());
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot obtain relationship properties: ", (Throwable)e);
        }
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        Query query = null;
        if (relationship.getName() == null) {
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName());
        } else {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)relationship.getName())).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName and r.name.name like :name").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName()).setParameter("name", (Object)relationship.getName());
        }
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = (HibernateIdentityObjectRelationship)query.uniqueResult();
            hibernateRelationship.getProperties().putAll(properties);
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot update relationship properties: ", (Throwable)e);
        }
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        Query query = null;
        if (relationship.getName() == null) {
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName());
        } else {
            HibernateIdentityObjectRelationshipName relationshipName = (HibernateIdentityObjectRelationshipName)this.getHibernateSession(ctx).createCriteria(HibernateIdentityObjectRelationshipName.class).add((Criterion)Restrictions.eq((String)"name", (Object)relationship.getName())).uniqueResult();
            if (relationshipName == null) {
                throw new IdentityException("Relationship name not present in the store");
            }
            query = this.getHibernateSession(ctx).createQuery("select r from HibernateIdentityObjectRelationship r where r.fromIdentityObject = :fromIO and r.toIdentityObject = :toIO and r.type.name like :typeName and r.name.name like :name").setParameter("fromIO", (Object)fromIO).setParameter("toIO", (Object)toIO).setParameter("typeName", (Object)type.getName()).setParameter("name", (Object)relationship.getName());
        }
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = (HibernateIdentityObjectRelationship)query.uniqueResult();
            for (String property : properties) {
                hibernateRelationship.getProperties().remove(property);
            }
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot update relationship properties: ", (Throwable)e);
        }
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        this.checkIOType(identityType);
        if (this.attributeMappings.containsKey(identityType.getName())) {
            return this.attributeMappings.get(identityType.getName());
        }
        return new HashSet<String>();
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext ctx, IdentityObject identity, String name) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Set<HibernateIdentityObjectAttribute> storeAttributes = hibernateObject.getAttributes();
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String mappedName = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), name);
            if (mappedName == null) continue;
            return attribute;
        }
        return null;
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Set<HibernateIdentityObjectAttribute> storeAttributes = hibernateObject.getAttributes();
        HashMap<String, IdentityObjectAttribute> result = new HashMap<String, IdentityObjectAttribute>();
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String name = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), attribute.getName());
            if (name == null) continue;
            result.put(name, attribute);
        }
        return result;
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributesMetaData.get(identityType.getName());
    }

    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        for (IdentityObjectAttribute attribute : attributes) {
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            if (amd == null) continue;
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                throw new IdentityException("Cannot update readonly attribute: " + attribute.getName());
            }
            String type = amd.getType();
            for (Object value : attribute.getValues()) {
                if (type.equals("text") && !(value instanceof String)) {
                    throw new IdentityException("Cannot update text type attribute with not String type value: " + attribute.getName() + " / " + value);
                }
                if (!type.equals("binary") || value instanceof byte[]) continue;
                throw new IdentityException("Cannot update binary type attribute with not byte[] type value: " + attribute.getName() + " / " + value);
            }
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        block2: for (String name : mappedAttributes.keySet()) {
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            String type = amd != null ? amd.getType() : "text";
            for (HibernateIdentityObjectAttribute storeAttribute : hibernateObject.getAttributes()) {
                HashSet<String> v;
                if (!storeAttribute.getName().equals(name)) continue;
                if (storeAttribute instanceof HibernateIdentityObjectTextAttribute) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ". Attribute name: " + name);
                    }
                    v = new HashSet<String>();
                    for (Object value : attribute.getValues()) {
                        v.add(value.toString());
                    }
                    ((HibernateIdentityObjectTextAttribute)storeAttribute).setValues(v);
                    continue block2;
                }
                if (storeAttribute instanceof HibernateIdentityObjectBinaryAttribute) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ". Attribute name: " + name);
                    }
                    v = new HashSet();
                    for (Object value : attribute.getValues()) {
                        v.add((String)((byte[])value));
                    }
                    ((HibernateIdentityObjectBinaryAttribute)storeAttribute).setValues(v);
                    continue block2;
                }
                throw new IdentityException("Internal identity store error");
            }
        }
    }

    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        org.hibernate.Session hibernateSession = this.getHibernateSession(ctx);
        for (IdentityObjectAttribute attribute : attributes) {
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            if (amd == null) continue;
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot add multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                throw new IdentityException("Cannot add readonly attribute: " + attribute.getName());
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute value : attribute.getValues()) {
                if (type.equals("text") && !(value instanceof String)) {
                    throw new IdentityException("Cannot add text type attribute with not String type value: " + attribute.getName() + " / " + value);
                }
                if (!type.equals("binary") || value instanceof byte[]) continue;
                throw new IdentityException("Cannot add binary type attribute with not byte[] type value: " + attribute.getName() + " / " + value);
            }
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        for (String name : mappedAttributes.keySet()) {
            HashSet<String> values;
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            String type = amd != null ? amd.getType() : "text";
            HibernateIdentityObjectAttribute hibernateAttribute = null;
            for (HibernateIdentityObjectAttribute storeAttribute : hibernateObject.getAttributes()) {
                if (!storeAttribute.getName().equals(name)) continue;
                hibernateAttribute = storeAttribute;
                break;
            }
            if (hibernateAttribute != null) {
                HashSet<String> mergedValues;
                if (hibernateAttribute instanceof HibernateIdentityObjectTextAttribute) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ". Attribute name: " + name);
                    }
                    mergedValues = new HashSet<String>(hibernateAttribute.getValues());
                    for (Object value : attribute.getValues()) {
                        mergedValues.add(value.toString());
                    }
                    ((HibernateIdentityObjectTextAttribute)hibernateAttribute).setValues(mergedValues);
                    break;
                }
                if (hibernateAttribute instanceof HibernateIdentityObjectBinaryAttribute) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ". Attribute name: " + name);
                    }
                    mergedValues = new HashSet(hibernateAttribute.getValues());
                    for (Object value : attribute.getValues()) {
                        mergedValues.add((String)((byte[])value));
                    }
                    ((HibernateIdentityObjectBinaryAttribute)hibernateAttribute).setValues(mergedValues);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (type.equals("text")) {
                values = new HashSet<String>();
                for (Object value : attribute.getValues()) {
                    values.add(value.toString());
                }
                hibernateAttribute = new HibernateIdentityObjectTextAttribute(hibernateObject, name, values);
            } else if (type.equals("binary")) {
                values = new HashSet();
                for (Object value : attribute.getValues()) {
                    values.add((String)((byte[])value));
                }
                hibernateAttribute = new HibernateIdentityObjectBinaryAttribute(hibernateObject, name, (Set<byte[]>)values);
            }
            hibernateObject.addAttribute(hibernateAttribute);
        }
    }

    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, String[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        String[] mappedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            String name;
            mappedAttributes[i] = name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attributes[i]);
            Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
            if (mdMap != null) {
                IdentityObjectAttributeMetaData amd = mdMap.get(attributes[i]);
                if (amd == null || !amd.isRequired()) continue;
                throw new IdentityException("Cannot remove required attribute: " + attributes[i]);
            }
            if (this.isAllowNotDefinedAttributes) continue;
            throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attributes[i]);
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        for (String attr : mappedAttributes) {
            hibernateObject.removeAttribute(attr);
        }
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) {
            HibernateIdentityObjectCredential hibernateCredential = null;
            hibernateCredential = (HibernateIdentityObjectCredential)this.getHibernateSession(ctx).createQuery("select c from HibernateIdentityObjectCredential c where c.type.name like :typeName and c.identityObject = :identityObject").setParameter("typeName", (Object)credential.getType().getName()).setParameter("identityObject", (Object)hibernateObject).uniqueResult();
            if (hibernateCredential == null) {
                return false;
            }
            Object value = null;
            value = credential.getEncodedValue() != null ? credential.getEncodedValue() : credential.getValue();
            if (value instanceof String && hibernateCredential.getTextValue() != null) {
                return value.toString().equals(hibernateCredential.getTextValue());
            }
            if (value instanceof byte[] && hibernateCredential.getBinaryValue() != null) {
                return Arrays.equals((byte[])value, hibernateCredential.getBinaryValue());
            }
            throw new IdentityException("Not supported credential value: " + value.getClass());
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        org.hibernate.Session em = this.getHibernateSession(ctx);
        if (!this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
        HibernateIdentityObjectCredentialType hibernateCredentialType = this.getHibernateIdentityObjectCredentialType(ctx, credential.getType());
        if (hibernateCredentialType == null) {
            throw new IllegalStateException("Credential type not present in this store: " + credential.getType().getName());
        }
        HibernateIdentityObjectCredential hibernateCredential = hibernateObject.getCredential(credential.getType());
        if (hibernateCredential == null) {
            hibernateCredential = new HibernateIdentityObjectCredential();
            hibernateCredential.setType(hibernateCredentialType);
            hibernateObject.addCredential(hibernateCredential);
        }
        Object value = null;
        value = credential.getEncodedValue() != null ? credential.getEncodedValue() : credential.getValue();
        if (value instanceof String) {
            hibernateCredential.setTextValue(value.toString());
        } else {
            if (!(value instanceof byte[])) throw new IdentityException("Not supported credential value: " + value.getClass());
            hibernateCredential.setBinaryValue((byte[])value);
        }
        em.persist((Object)hibernateCredential);
        hibernateObject.addCredential(hibernateCredential);
    }

    public void addIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        HibernateIdentityObjectType hibernateType = new HibernateIdentityObjectType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
    }

    public void addIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType type) throws IdentityException {
        HibernateIdentityObjectRelationshipType hibernateType = new HibernateIdentityObjectRelationshipType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
    }

    protected org.hibernate.Session getHibernateSession(IdentityStoreInvocationContext ctx) throws IdentityException {
        try {
            return (org.hibernate.Session)ctx.getIdentityStoreSession().getSessionContext();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot obtain Hibernate Session", (Throwable)e);
        }
    }

    private void checkIOInstance(IdentityObject io) {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
    }

    private HibernateIdentityObject safeGet(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        this.checkIOInstance(io);
        if (io instanceof HibernateIdentityObject) {
            return (HibernateIdentityObject)io;
        }
        return this.getHibernateIdentityObject(ctx, io);
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.getSupportedFeatures().isIdentityObjectTypeSupported(iot)) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + iot);
        }
    }

    private HibernateIdentityObjectType getHibernateIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        HibernateIdentityObjectType hibernateType = null;
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            hibernateType = (HibernateIdentityObjectType)em.createQuery("select t from HibernateIdentityObjectType t where t.name like :name").setParameter("name", (Object)type.getName()).uniqueResult();
        }
        catch (HibernateException e) {
            throw new IdentityException("IdentityObjectType[" + type.getName() + "] not present in the store.", (Throwable)e);
        }
        return hibernateType;
    }

    private HibernateIdentityObject getHibernateIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        HibernateIdentityObject hibernateObject = null;
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            hibernateObject = (HibernateIdentityObject)em.createQuery("select o from HibernateIdentityObject o where o.realm = :realm and o.name like :name and o.identityType.name like :typeName").setParameter("name", (Object)io.getName()).setParameter("typeName", (Object)io.getIdentityType().getName()).setParameter("realm", (Object)this.getRealm(em, ctx)).uniqueResult();
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + io.getIdentityType().getName() + "] not present in the store.", (Throwable)e);
        }
        return hibernateObject;
    }

    private HibernateIdentityObjectRelationshipType getHibernateIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType iot) throws IdentityException {
        HibernateIdentityObjectRelationshipType relationshipType = null;
        org.hibernate.Session em = this.getHibernateSession(ctx);
        try {
            relationshipType = (HibernateIdentityObjectRelationshipType)em.createQuery("select t from HibernateIdentityObjectRelationshipType t where t.name like :name").setParameter("name", (Object)iot.getName()).uniqueResult();
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObjectRelationshipType[ " + iot.getName() + "] not present in the store.");
        }
        return relationshipType;
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(IdentityStoreInvocationContext ctx, IdentityObjectCredentialType credentialType) throws IdentityException {
        org.hibernate.Session session = this.getHibernateSession(ctx);
        HibernateIdentityObjectCredentialType hibernateType = null;
        try {
            hibernateType = (HibernateIdentityObjectCredentialType)session.createCriteria(HibernateIdentityObjectCredentialType.class).add((Criterion)Restrictions.eq((String)"name", (Object)credentialType.getName())).uniqueResult();
        }
        catch (HibernateException e) {
            throw new IdentityException("IdentityObjectCredentialType[ " + credentialType.getName() + "] not present in the store.");
        }
        return hibernateType;
    }

    public void populateObjectTypes(org.hibernate.Session hibernateSession, String[] typeNames) throws Exception {
        hibernateSession.getTransaction().begin();
        for (String typeName : typeNames) {
            HibernateIdentityObjectType hibernateType = (HibernateIdentityObjectType)hibernateSession.createCriteria(HibernateIdentityObjectType.class).add((Criterion)Restrictions.eq((String)"name", (Object)typeName)).uniqueResult();
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
        hibernateSession.getTransaction().commit();
    }

    public void populateRelationshipTypes(org.hibernate.Session hibernateSession, String[] typeNames) throws Exception {
        hibernateSession.getTransaction().begin();
        for (String typeName : typeNames) {
            HibernateIdentityObjectRelationshipType hibernateType = (HibernateIdentityObjectRelationshipType)hibernateSession.createCriteria(HibernateIdentityObjectRelationshipType.class).add((Criterion)Restrictions.eq((String)"name", (Object)typeName)).uniqueResult();
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectRelationshipType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
        hibernateSession.getTransaction().commit();
    }

    public void populateCredentialTypes(org.hibernate.Session hibernateSession, String[] typeNames) throws Exception {
        hibernateSession.getTransaction().begin();
        for (String typeName : typeNames) {
            HibernateIdentityObjectCredentialType hibernateType = (HibernateIdentityObjectCredentialType)hibernateSession.createCriteria(HibernateIdentityObjectCredentialType.class).add((Criterion)Restrictions.eq((String)"name", (Object)typeName)).uniqueResult();
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectCredentialType(typeName);
            hibernateSession.persist((Object)hibernateType);
        }
        hibernateSession.getTransaction().commit();
    }

    public void addRealm(org.hibernate.Session hibernateSession, String realmName) throws IdentityException {
        try {
            hibernateSession.getTransaction().begin();
            HibernateRealm realm = new HibernateRealm(realmName);
            hibernateSession.persist((Object)realm);
            hibernateSession.getTransaction().commit();
        }
        catch (Exception e) {
            throw new IdentityException("Failed to create store realm", (Throwable)e);
        }
    }

    public HibernateRealm getRealm(org.hibernate.Session hibernateSession, IdentityStoreInvocationContext ctx) throws IdentityException {
        if (ctx.getRealmId() == null) {
            throw new IllegalStateException("Realm Id not present");
        }
        HibernateRealm realm = null;
        if (!this.isRealmAware()) {
            realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)DEFAULT_REALM_NAME)).uniqueResult();
            if (realm == null) {
                throw new IllegalStateException("Default store realm is not present: " + DEFAULT_REALM_NAME);
            }
        } else {
            realm = (HibernateRealm)hibernateSession.createCriteria(HibernateRealm.class).add((Criterion)Restrictions.eq((String)"name", (Object)ctx.getRealmId())).uniqueResult();
            if (realm == null) {
                HibernateRealm newRealm = new HibernateRealm(ctx.getRealmId());
                hibernateSession.persist((Object)newRealm);
                return newRealm;
            }
        }
        return realm;
    }

    private boolean isRealmAware() {
        return this.isRealmAware;
    }

    private boolean isAllowNotDefinedAttributes() {
        return this.isAllowNotDefinedAttributes;
    }

    private String resolveAttributeStoreMapping(IdentityObjectType type, String name) throws IdentityException {
        IdentityObjectAttributeMetaData amd;
        String mapping = null;
        if (this.attributesMetaData.containsKey(type.getName()) && (amd = this.attributesMetaData.get(type.getName()).get(name)) != null) {
            mapping = amd.getStoreMapping() != null ? amd.getStoreMapping() : amd.getName();
            return mapping;
        }
        if (this.isAllowNotDefinedAttributes()) {
            mapping = name;
            return mapping;
        }
        throw new IdentityException("Attribute name is not configured in this store");
    }

    private String resolveAttributeNameFromStoreMapping(IdentityObjectType type, String mapping) {
        Map<String, String> map;
        if (this.reverseAttributeMappings.containsKey(type.getName()) && (map = this.reverseAttributeMappings.get(type.getName())) != null) {
            String name = map.containsKey(mapping) ? map.get(mapping) : mapping;
            return name;
        }
        if (this.isAllowNotDefinedAttributes()) {
            return mapping;
        }
        return null;
    }

    private void filterByAttributesValues(Collection<IdentityObject> objects, Map<String, String[]> attrs) {
        HashSet<IdentityObject> toRemove = new HashSet<IdentityObject>();
        block0: for (IdentityObject object : objects) {
            Map<String, Collection> presentAttrs = ((HibernateIdentityObject)object).getAttributesAsMap();
            block1: for (Map.Entry<String, String[]> entry : attrs.entrySet()) {
                if (presentAttrs.containsKey(entry.getKey())) {
                    HashSet<Object> given = new HashSet<Object>(Arrays.asList((Object[])entry.getValue()));
                    Collection present = presentAttrs.get(entry.getKey());
                    for (String string : given) {
                        if (present.contains(string)) continue;
                        toRemove.add(object);
                        continue block1;
                    }
                    continue;
                }
                toRemove.add(object);
                continue block0;
            }
        }
        for (IdentityObject identityObject : toRemove) {
            objects.remove(identityObject);
        }
    }

    static {
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.ATTRIBUTE_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.NAME_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.PAGE);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.SORT);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_PASSWORD);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_BINARY);
    }
}

