/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.model.hibernate;

import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import javax.persistence.Column;
import javax.persistence.ManyToOne;
import javax.persistence.JoinColumn;
import javax.persistence.UniqueConstraint;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import java.util.Set;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
@Entity
@Inheritance(strategy = InheritanceType.JOINED)
@Table(name = "jbid_io_attr", uniqueConstraints = {@UniqueConstraint(columnNames = {"NAME", "IDENTITY_OBJECT_ID"})})
public abstract class HibernateIdentityObjectAttribute implements IdentityObjectAttribute
{
   @Id
   @GeneratedValue
   @Column(name="ATTRIBUTE_ID")
   private Long id;

   @ManyToOne
   @JoinColumn(name="IDENTITY_OBJECT_ID", nullable = false)
   private HibernateIdentityObject identityObject;

   @Column(name = "NAME")
   private String name;

   public HibernateIdentityObjectAttribute()
   {
   }

   public HibernateIdentityObjectAttribute(HibernateIdentityObject identityObject, String name)                                       
   {
      this.identityObject = identityObject;
      this.name = name;
   }

   public HibernateIdentityObjectAttribute(HibernateIdentityObject identityObject, String name, Set<String> values)
   {
      this.identityObject = identityObject;
      this.name = name;
   }

   public HibernateIdentityObjectAttribute(HibernateIdentityObject identityObject, String name, String[] values)
   {
      this.identityObject = identityObject;
      this.name = name;
   }

   public Long getId()
   {
      return id;
   }

   public void setId(Long id)
   {
      this.id = id;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   @SuppressWarnings("unchecked")
   public void addValue(String val)
   {
      getValues().add(val);
   }

   public HibernateIdentityObject getIdentityObject()
   {
      return identityObject;
   }

   public void setIdentityObject(HibernateIdentityObject identityObject)
   {
      this.identityObject = identityObject;
   }

}
