/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import bsh.EvalError;
import bsh.Interpreter;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.jboss.identity.idm.api.cfg.IdentityConfiguration;
import org.jboss.identity.idm.common.transaction.TransactionManagerProvider;
import org.jboss.identity.idm.common.transaction.Transactions;
import org.jboss.identity.idm.integration.jboss5.jaxb2.HibernateInitializerType;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.common.util.CLResourceLoader;
import org.jboss.portal.common.util.LoaderResource;

public class HibernatePopulator {
    private static Logger logger = Logger.getLogger(HibernatePopulator.class.getName());
    private static final int RESULT_NONE = 0;
    private static final int RESULT_UPDATE = 1;
    private static final int RESULT_CREATE = 2;
    private Configuration config;
    private SessionFactory sessionFactory;
    private HibernateInitializerType type;
    private String hibernateSessionFactoryJNDIName;
    private IdentityConfiguration identityConfiguration;

    public HibernatePopulator(HibernateInitializerType type, IdentityConfiguration identityConfig) {
        this.type = type;
        this.identityConfiguration = identityConfig;
    }

    public void populateSchema() throws Exception {
        if (this.type.getHibernateConfigLocation() != null) {
            URL configURL = Thread.currentThread().getContextClassLoader().getResource(this.type.getHibernateConfigLocation());
            if (configURL == null) {
                throw new Exception("The config " + this.type.getHibernateConfigLocation() + " does not exist");
            }
            if (!URLTools.exists((URL)configURL)) {
                throw new Exception("The config " + configURL + " does not exist");
            }
            this.config = new AnnotationConfiguration().configure(configURL);
            this.createHibernateSessionFactory();
            InitialContext context = new InitialContext();
            if (this.getHibernateSessionFactoryJNDIName() != null) {
                try {
                    context.bind(this.getHibernateSessionFactoryJNDIName(), (Object)this.sessionFactory);
                }
                catch (NamingException e) {
                    logger.severe(e.getMessage());
                }
            }
            if (this.type.getHibernateSessionFactoryRegistryName() != null) {
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)this.sessionFactory, this.type.getHibernateSessionFactoryRegistryName());
            }
            if (this.type.isDoChecking()) {
                int check = this.doCheck();
                switch (check) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.updateSchema();
                        break;
                    }
                    case 2: {
                        this.createSchema();
                        this.createContent();
                    }
                }
            } else {
                this.createSchema();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCheck() {
        Session session = null;
        int numOfChecks = 0;
        int bad = 0;
        try {
            session = this.sessionFactory.openSession();
            Collection values = this.sessionFactory.getAllClassMetadata().values();
            numOfChecks = values.size();
            for (ClassMetadata cmd : values) {
                Query query = session.createQuery("from " + cmd.getEntityName());
                query.setFirstResult(0);
                query.setMaxResults(0);
                try {
                    query.list();
                }
                catch (SQLGrammarException e) {
                    ++bad;
                }
            }
        }
        finally {
            this.sessionFactory.close();
        }
        if (bad == 0) {
            logger.fine("The schema was checked as valid");
            return 0;
        }
        if (bad == numOfChecks) {
            logger.fine("The schema was checked as not exists");
            return 2;
        }
        if (bad < numOfChecks) {
            logger.fine("The schema was checked as need updates");
            return 1;
        }
        logger.fine("The schema was checked as need to be created");
        return 2;
    }

    private void createSchema() {
        logger.fine("Creating database schema");
        SchemaExport export = new SchemaExport(this.config);
        export.create(false, true);
    }

    private void destroySchema() {
        logger.fine("Destroying database schema");
        SchemaExport export = new SchemaExport(this.config);
        export.drop(false, true);
    }

    private void updateSchema() {
        logger.fine("Updating database schema");
        SchemaUpdate update = new SchemaUpdate(this.config);
        update.execute(false, true);
    }

    public String getHibernateSessionFactoryJNDIName() {
        return this.hibernateSessionFactoryJNDIName;
    }

    public void setHibernateSessionFactoryJNDIName(String hibernateSessionFactoryJNDIName) {
        this.hibernateSessionFactoryJNDIName = hibernateSessionFactoryJNDIName;
    }

    private void createHibernateSessionFactory() throws Exception {
        if (this.getHibernateSessionFactoryJNDIName() != null) {
            this.setPropertyIfAbsent("hibernate.session_factory_name", this.getHibernateSessionFactoryJNDIName());
        }
        this.sessionFactory = this.config.buildSessionFactory();
    }

    private void setPropertyIfAbsent(String name, String value) {
        if (this.config.getProperty(name) == null) {
            this.config.setProperty(name, value);
        }
    }

    private void createContent() {
        LoaderResource setupResource = null;
        if (this.type.getSetupLocation() != null && setupResource == null) {
            setupResource = new CLResourceLoader().getResource(this.type.getSetupLocation());
        }
        if (setupResource != null) {
            if (setupResource.exists()) {
                try {
                    logger.info("Creating database content");
                    final String script = setupResource.asString("UTF-8");
                    final Interpreter interpreter = new Interpreter();
                    interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
                    interpreter.setOut(System.out);
                    interpreter.set("SessionFactory", (Object)this.sessionFactory);
                    TransactionManager tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
                    Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                        public Object run() throws Exception {
                            interpreter.eval(script);
                            return null;
                        }
                    });
                }
                catch (EvalError e) {
                    logger.info("Error in the bsh script: " + (Object)((Object)e));
                }
                catch (IllegalStateException e) {
                    logger.info("Cannot load setup script: " + e);
                }
                catch (Exception e) {
                    logger.info("Error in bsh script execution: " + e);
                }
            } else {
                logger.info("There is a setup URL but the not valid " + setupResource);
            }
        }
    }
}

