/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.api;

import java.util.Collection;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.RelationshipManagerFeaturesDescription;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.common.exception.IdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RelationshipManager {
    public IdentitySession getIdentitySession();

    public RelationshipManagerFeaturesDescription getFeaturesDescription();

    public IdentitySearchCriteria createIdentitySearchCriteria();

    public void associateGroups(Collection<Group> var1, Collection<Group> var2) throws IdentityException;

    public void associateGroups(Group var1, Collection<Group> var2) throws IdentityException;

    public void associateGroupsByIds(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void associateGroupsByIds(String var1, Collection<String> var2) throws IdentityException;

    public void associateGroups(Group var1, Group var2) throws IdentityException;

    public void associateGroupsByIds(String var1, String var2) throws IdentityException;

    public void associateUsers(Collection<Group> var1, Collection<User> var2) throws IdentityException;

    public void associateUser(Group var1, Collection<User> var2) throws IdentityException;

    public void associateUsersByIds(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void associateUsersByIds(String var1, Collection<String> var2) throws IdentityException;

    public void associateUser(Group var1, User var2) throws IdentityException;

    public void associateUserByIds(String var1, String var2) throws IdentityException;

    public void disassociateGroups(Collection<Group> var1, Collection<Group> var2) throws IdentityException;

    public void disassociateGroups(Group var1, Collection<Group> var2) throws IdentityException;

    public void disassociateGroupsByIds(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void disassociateGroupsByIds(String var1, Collection<String> var2) throws IdentityException;

    public void disassociateUsers(Collection<Group> var1, Collection<User> var2) throws IdentityException;

    public void disassociateUsers(Group var1, Collection<User> var2) throws IdentityException;

    public void disassociateUsersByIds(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public void disassociateUsersByIds(String var1, Collection<String> var2) throws IdentityException;

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(Collection<G> var1, Collection<I> var2) throws IdentityException;

    public boolean isAssociatedByIds(Collection<String> var1, Collection<String> var2) throws IdentityException;

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(G var1, I var2) throws IdentityException;

    public boolean isAssociatedByIds(String var1, String var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(Group var1, String var2, boolean var3, boolean var4) throws IdentityException;

    public Collection<Group> findAssociatedGroups(Group var1, String var2, boolean var3, boolean var4, IdentitySearchCriteria var5) throws IdentityException;

    public Collection<Group> findAssociatedGroups(String var1, String var2, boolean var3, boolean var4, IdentitySearchCriteria var5) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1, String var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findAssociatedGroups(String var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(String var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<Group> findAssociatedGroups(User var1) throws IdentityException;

    public Collection<User> findAssociatedUsers(Group var1, boolean var2) throws IdentityException;

    public Collection<User> findAssociatedUsers(Group var1, boolean var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<User> findAssociatedUsers(String var1, boolean var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findRelatedGroups(User var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<Group> findRelatedGroups(String var1, String var2, IdentitySearchCriteria var3) throws IdentityException;

    public Collection<User> findRelatedUsers(Group var1, IdentitySearchCriteria var2) throws IdentityException;

    public Collection<User> findRelatedUsers(String var1, IdentitySearchCriteria var2) throws IdentityException;
}

