/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.AttributeDescription;
import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.Credential;
import org.jboss.identity.idm.api.CredentialType;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.PasswordCredential;
import org.jboss.identity.idm.impl.api.SimpleAttribute;
import org.jboss.identity.idm.impl.api.SimpleCredentialType;
import org.jboss.identity.idm.impl.api.attribute.IdentityObjectAttributeMetaDataImpl;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesManagerImpl
extends AbstractManager
implements AttributesManager,
Serializable {
    private static final long serialVersionUID = 1285532201632609092L;

    public AttributesManagerImpl(IdentitySession session) {
        super(session);
    }

    @Override
    public AttributeDescription getAttributeDescription(IdentityType identityType, String name) {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(name, "Attribute name");
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        if (mdMap != null && mdMap.containsKey(name)) {
            IdentityObjectAttributeMetaData attributeMD = mdMap.get(name);
            if (attributeMD instanceof AttributeDescription) {
                return (AttributeDescription)((Object)attributeMD);
            }
            return new IdentityObjectAttributeMetaDataImpl(attributeMD);
        }
        return null;
    }

    @Override
    public AttributeDescription getAttributeDescription(String id, String attributeName) {
        this.checkNotNullArgument(id, "IdentityType Id");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributeDescription(identityType, attributeName);
    }

    @Override
    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        HashMap<String, AttributeDescription> descriptionMap = new HashMap<String, AttributeDescription>();
        if (mdMap != null) {
            for (IdentityObjectAttributeMetaData attributeMD : mdMap.values()) {
                if (attributeMD instanceof AttributeDescription) {
                    descriptionMap.put(attributeMD.getName(), (AttributeDescription)((Object)attributeMD));
                    continue;
                }
                descriptionMap.put(attributeMD.getName(), new IdentityObjectAttributeMetaDataImpl(attributeMD));
            }
        }
        return descriptionMap;
    }

    @Override
    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(String id) {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributesDescriptions(identityType);
    }

    @Override
    public Set<String> getSupportedAttributeNames(IdentityType identityType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        return this.getRepository().getSupportedAttributeNames(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
    }

    @Override
    public Set<String> getSupportedAttributeNames(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributeNames(identityType);
    }

    @Override
    public Map<String, Attribute> getAttributes(IdentityType identityType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        Map<String, IdentityObjectAttribute> map = this.getRepository().getAttributes(this.getInvocationContext(), this.createIdentityObject(identityType));
        HashMap<String, Attribute> newMap = new HashMap<String, Attribute>();
        for (Map.Entry<String, IdentityObjectAttribute> entry : map.entrySet()) {
            newMap.put(entry.getKey(), this.convertAttribute(entry.getValue()));
        }
        return newMap;
    }

    @Override
    public Map<String, Attribute> getAttributes(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributes(identityType);
    }

    @Override
    public void updateAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributes, "Attributes");
        this.getRepository().updateAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
    }

    @Override
    public void updateAttributes(String id, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributes, "Attributes");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.updateAttributes(identityType, attributes);
    }

    @Override
    public Attribute getAttribute(IdentityType identityType, String attributeName) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        return this.getAttributes(identityType).get(attributeName);
    }

    @Override
    public Attribute getAttribute(String id, String attributeName) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttribute(identityType, attributeName);
    }

    @Override
    public void addAttribute(IdentityType identityType, String attributeName, Object[] values) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(values, "Attribute values");
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, values)};
        this.addAttributes(identityType, attrs);
    }

    @Override
    public void addAttributes(String id, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributes, "Attributes");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttributes(identityType, attributes);
    }

    @Override
    public void addAttribute(IdentityType identityType, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, value)};
        this.addAttributes(identityType, attrs);
    }

    @Override
    public void addAttribute(String id, String attributeName, Object[] values) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(values, "Attribute values");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttribute(identityType, attributeName, values);
    }

    @Override
    public void addAttribute(String id, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttribute(identityType, attributeName, value);
    }

    @Override
    public void addAttributes(IdentityType identityType, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributes, "Attributes");
        this.getRepository().addAttributes(this.getInvocationContext(), this.createIdentityObject(identityType), this.convertAttributes(attributes));
    }

    @Override
    public void removeAttributes(IdentityType identityType, String[] attributeNames) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(attributeNames, "Attribute names");
        this.getRepository().removeAttributes(this.getInvocationContext(), this.createIdentityObject(identityType), attributeNames);
    }

    @Override
    public void removeAttributes(String id, String[] attributeNames) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeNames, "Attribute names");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.removeAttributes(identityType, attributeNames);
    }

    @Override
    public boolean hasPassword(User user) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.createIdentityObject(user).getIdentityType(), PasswordCredential.TYPE);
    }

    @Override
    public boolean validatePassword(User user, String password) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(password, "Password");
        return this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), new PasswordCredential(password));
    }

    @Override
    public void updatePassword(User user, String password) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(password, "Password");
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(user), new PasswordCredential(password));
    }

    @Override
    public boolean isCredentialTypeSupported(CredentialType credentialType) throws IdentityException {
        this.checkNotNullArgument(credentialType, "CredentialType");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.getUserObjectType(), new SimpleCredentialType(credentialType.getName()));
    }

    @Override
    public boolean validateCredentials(User user, Credential[] credentials) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(credentials, "Credentials");
        for (Credential credential : credentials) {
            IdentityObjectCredential ioc = null;
            if (!(credential instanceof IdentityObjectCredential)) {
                throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
            }
            ioc = (IdentityObjectCredential)((Object)credential);
            if (this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), ioc)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateCredential(User user, Credential credential) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(credential, "Credential");
        if (!(credential instanceof IdentityObjectCredential)) {
            throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
        }
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(user), (IdentityObjectCredential)((Object)credential));
    }
}

