/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.IdentitySearchCriteriumType;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.PersistenceManager;
import org.jboss.identity.idm.api.PersistenceManagerFeaturesDescription;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerImpl
extends AbstractManager
implements PersistenceManager,
Serializable {
    private final PersistenceManagerFeaturesDescription featuresDescription = new PersistenceManagerFeaturesDescription(){

        public boolean isUsersAddRemoveSupported() {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isGroupsAddRemoveSupported(String groupType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isUsersSearchCriteriumTypeSupported(IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf(constraintType.name());
            if (constraint != null) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }

        public boolean isGroupsSearchCriteriumTypeSupported(String groupType, IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf(constraintType.name());
            if (constraint != null) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }
    };
    private static final long serialVersionUID = -4691446225503953920L;

    public PersistenceManagerImpl(IdentitySession session) {
        super(session);
    }

    @Override
    public PersistenceManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    @Override
    public User createUser(String identityName) throws IdentityException {
        this.checkNotNullArgument(identityName, "Identity name");
        this.checkObjectName(identityName);
        IdentityObjectType iot = this.getUserObjectType();
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), identityName, iot);
        return this.createUser(identityObject);
    }

    @Override
    public Group createGroup(String groupName, String groupType) throws IdentityException {
        this.checkNotNullArgument(groupName, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        this.checkObjectName(groupName);
        this.checkObjectName(groupType);
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), groupName, iot);
        return this.createGroup(identityObject);
    }

    @Override
    public String createGroupId(String groupName, String groupType) {
        this.checkNotNullArgument(groupName, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        this.checkObjectName(groupName);
        this.checkObjectName(groupType);
        return new GroupId(groupName, groupType).getId();
    }

    @Override
    public void removeUser(User user, boolean force) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(user));
    }

    @Override
    public void removeUser(String userName, boolean force) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObjectForUserName(userName));
    }

    @Override
    public void removeGroup(Group group, boolean force) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(group));
    }

    @Override
    public void removeGroup(String groupId, boolean force) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObjectForGroupId(groupId));
    }

    @Override
    public int getUserCount() throws IdentityException {
        IdentityObjectType iot = this.getUserObjectType();
        return this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
    }

    @Override
    public int getGroupTypeCount(String groupType) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        return this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
    }

    @Override
    public User findUser(String name) throws IdentityException {
        this.checkNotNullArgument(name, "User name");
        IdentityObject io = this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getUserObjectType());
        if (io != null) {
            return this.createUser(io);
        }
        return null;
    }

    @Override
    public Collection<User> findUser(IdentitySearchCriteria criteria) throws IdentityException {
        Collection<IdentityObject> ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getUserObjectType(), this.convertSearchControls(criteria));
        LinkedList<User> identities = new LinkedList<User>();
        for (IdentityObject identityObject : ios) {
            identities.add(this.createUser(identityObject));
        }
        return identities;
    }

    @Override
    public Group findGroup(String name, String groupType) throws IdentityException {
        this.checkNotNullArgument(name, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        IdentityObject io = this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getIdentityObjectType(groupType));
        if (io != null) {
            return this.createGroup(io);
        }
        return null;
    }

    @Override
    public Group findGroupById(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Group id");
        IdentityObject io = this.getRepository().findIdentityObject(this.getInvocationContext(), id);
        if (io != null) {
            return this.createGroup(io);
        }
        return null;
    }

    @Override
    public Collection<Group> findGroup(String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        Collection<IdentityObject> ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getIdentityObjectType(groupType), this.convertSearchControls(criteria));
        LinkedList<Group> groups = new LinkedList<Group>();
        for (IdentityObject identityObject : ios) {
            groups.add(this.createGroup(identityObject));
        }
        return groups;
    }

    @Override
    public Collection<Group> findGroup(String groupType) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        return this.findGroup(groupType, (IdentitySearchCriteria)null);
    }
}

